/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.drive;

import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.document.Document;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.test.AbstractBaseTest;
import org.jbpm.workitem.google.drive.GoogleDriveAuth;
import org.jbpm.workitem.google.drive.MediaDownloadWorkitemHandler;
import org.jbpm.workitem.google.drive.MediaUploadWorkitemHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={MediaHttpUploader.class, MediaHttpDownloader.class, Drive.Files.Insert.class, Drive.Files.Get.class})
public class GoogleDriveWorkitemHandlerTest
extends AbstractBaseTest {
    @Mock
    GoogleDriveAuth auth;
    @Mock
    Drive gdriveService;
    @Mock
    Drive.Files gdriveFiles;
    private Document testDoc;

    @Before
    public void setUp() {
        try {
            InputStream testInputStream = IOUtils.toInputStream((String)"test doc content", (String)"UTF-8");
            MediaHttpUploader mediaHttpUploader = (MediaHttpUploader)PowerMockito.mock(MediaHttpUploader.class);
            MediaHttpDownloader mediaHttpDownloader = (MediaHttpDownloader)PowerMockito.mock(MediaHttpDownloader.class);
            Drive.Files.Insert gdriveFilesInsert = (Drive.Files.Insert)PowerMockito.mock(Drive.Files.Insert.class);
            Drive.Files.Get gdriveFilesGet = (Drive.Files.Get)PowerMockito.mock(Drive.Files.Get.class);
            PowerMockito.when((Object)this.auth.getDriveService(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.gdriveService);
            PowerMockito.when((Object)this.gdriveService.files()).thenReturn((Object)this.gdriveFiles);
            PowerMockito.when((Object)this.gdriveFiles.insert((File)Matchers.any(File.class), (AbstractInputStreamContent)Matchers.any(FileContent.class))).thenReturn((Object)gdriveFilesInsert);
            PowerMockito.when((Object)this.gdriveFiles.get(Matchers.anyString())).thenReturn((Object)gdriveFilesGet);
            PowerMockito.when((Object)gdriveFilesInsert.getMediaHttpUploader()).thenReturn((Object)mediaHttpUploader);
            PowerMockito.when((Object)gdriveFilesInsert.execute()).thenReturn((Object)new File());
            PowerMockito.when((Object)gdriveFilesGet.getMediaHttpDownloader()).thenReturn((Object)mediaHttpDownloader);
            PowerMockito.when((Object)gdriveFilesGet.executeMediaAsInputStream()).thenReturn((Object)testInputStream);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUpload() throws Exception {
        DocumentImpl testUploadDoc = new DocumentImpl();
        testUploadDoc.setContent(new String("Test file to upload").getBytes());
        testUploadDoc.setName("testFileToUpload.txt");
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("DocToUpload", (Object)testUploadDoc);
        workItem.setParameter("DocMimeType", (Object)"text/plain");
        workItem.setParameter("UploadPath", (Object)"/some/upload/path");
        MediaUploadWorkitemHandler handler = new MediaUploadWorkitemHandler("myAppName", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testDownload() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("DocumentPath", (Object)"/some/download/path/testdoc.txt");
        MediaDownloadWorkitemHandler handler = new MediaDownloadWorkitemHandler("myAppName", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("Document") instanceof Document));
        Document downloadedDoc = (Document)((Map)manager.getResults().get(workItem.getId())).get("Document");
        Assert.assertNotNull((Object)downloadedDoc);
        Assert.assertEquals((Object)"testdoc.txt", (Object)downloadedDoc.getName());
        Assert.assertEquals((Object)"/some/download/path/testdoc.txt", (Object)downloadedDoc.getIdentifier());
        Assert.assertEquals((Object)"test doc content", (Object)new String(downloadedDoc.getContent()));
    }
}

