/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.drive;

import com.google.api.client.googleapis.media.MediaHttpDownloaderProgressListener;
import com.google.api.services.drive.Drive;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.workitem.google.drive.GoogleDriveAuth;
import org.jbpm.workitem.google.drive.MediaDownloadProgressListener;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GoogleDownloadFromDriveDefinitions.wid", name="GoogleDownloadFromDrive", displayName="GoogleDownloadFromDrive", defaultHandler="mvel: new org.jbpm.process.workitem.google.drive.MediaDownloadWorkitemHandler()", parameters={@WidParameter(name="DocumentPath")}, results={@WidResult(name="Document")}, mavenDepends={@WidMavenDepends(group="com.google.api-client", artifact="google-api-client", version="1.23.0"), @WidMavenDepends(group="com.google.oauth-client", artifact="google-oauth-client-jetty", version="1.23.0"), @WidMavenDepends(group="com.google.apis", artifact="google-api-services-drive", version="v2-rev285-1.23.0")})
public class MediaDownloadWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String appName;
    private String clientSecret;
    private GoogleDriveAuth auth = new GoogleDriveAuth();
    private static final Logger logger = LoggerFactory.getLogger(MediaDownloadWorkitemHandler.class);
    private static final String RESULTS_DOCUMENT = "Document";

    public MediaDownloadWorkitemHandler(String appName, String clentSecret) {
        this.appName = appName;
        this.clientSecret = clentSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        HashMap<String, DocumentImpl> results = new HashMap<String, DocumentImpl>();
        String documentPath = (String)workItem.getParameter("DocumentPath");
        if (documentPath != null) {
            try {
                Drive drive = this.auth.getDriveService(this.appName, this.clientSecret);
                Drive.Files.Get request = drive.files().get(documentPath);
                request.getMediaHttpDownloader().setProgressListener((MediaHttpDownloaderProgressListener)new MediaDownloadProgressListener());
                request.getMediaHttpDownloader().setDirectDownloadEnabled(true);
                InputStream docInputStream = request.executeMediaAsInputStream();
                DocumentImpl doc = new DocumentImpl();
                String docBaseName = FilenameUtils.getBaseName((String)documentPath);
                String docExtension = FilenameUtils.getExtension((String)documentPath);
                doc.setName(docBaseName + "." + docExtension);
                doc.setIdentifier(documentPath);
                doc.setLastModified(new Date());
                doc.setContent(IOUtils.toByteArray((InputStream)docInputStream));
                results.put(RESULTS_DOCUMENT, doc);
                workItemManager.completeWorkItem(workItem.getId(), results);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        } else {
            logger.error("Missing download document information.");
            throw new IllegalArgumentException("Missing download document information.");
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GoogleDriveAuth auth) {
        this.auth = auth;
    }
}

