/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.camel.karaf.itests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.drools.core.process.instance.impl.DefaultWorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.camel.FileCamelWorkitemHandler;
import org.jbpm.process.workitem.camel.karaf.itests.AbstractKarafIntegrationTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;
import org.ops4j.pax.tinybundles.core.TinyBundles;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerClass.class})
public class CamelWorkitemIntegrationTest
extends AbstractKarafIntegrationTest {
    private static File tempDir;
    private static File testDir;
    private static File testFile;
    private static final String SPRING_XML_LOCATION = "/org/jbpm/process/workitem/camel/karaf/itests/workitem-camel-service.xml";
    private static final String PROCESS_LOCATION = "/org/jbpm/process/workitem/camel/karaf/itests/workitem/BPMN2-CamelFileProcess.bpmn2";
    private static final String CWD_LOCATION = "/org/jbpm/process/workitem/camel/karaf/itests/workitem/CamelWorkDefinitions.wid";
    @Inject
    private KieSession kieSession;

    @Configuration
    public static Option[] configure() {
        return new Option[]{CamelWorkitemIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.DEBUG), CamelWorkitemIntegrationTest.loadKieFeatures("jbpm", "drools-module", "jbpm-workitems-camel", "kie-spring"), KarafDistributionOption.features((UrlReference)CamelWorkitemIntegrationTest.getFeaturesUrl("org.apache.karaf.features", "spring-legacy", CamelWorkitemIntegrationTest.getKarafVersion()), (String[])new String[]{"aries-blueprint-spring"}), CoreOptions.wrappedBundle((UrlReference)CoreOptions.mavenBundle().groupId("commons-io").artifactId("commons-io").versionAsInProject()), CoreOptions.wrappedBundle((UrlReference)CoreOptions.mavenBundle().groupId("junit").artifactId("junit").versionAsInProject()), CoreOptions.wrappedBundle((UrlReference)CoreOptions.mavenBundle().groupId("junit").artifactId("junit").versionAsInProject()), (Option)CoreOptions.streamBundle((InputStream)TinyBundles.bundle().set("Bundle-ManifestVersion", "2").add("META-INF/spring/workitem-camel-service.xml", CamelWorkitemIntegrationTest.class.getResource(SPRING_XML_LOCATION)).add(PROCESS_LOCATION.substring(1), CamelWorkitemIntegrationTest.class.getResource(PROCESS_LOCATION)).add(CWD_LOCATION.substring(1), CamelWorkitemIntegrationTest.class.getResource(CWD_LOCATION)).set("Import-Package", "org.kie.osgi.spring,org.kie.api,org.kie.api.runtime,org.kie.api.runtime.manager,org.kie.api.runtime.process,org.kie.api.task,org.jbpm.persistence.processinstance,org.jbpm.runtime.manager.impl,org.jbpm.process.instance.impl,org.jbpm.services.task.identity,org.jbpm.services.task.impl.model,org.kie.internal.runtime.manager.context,javax.transaction,javax.persistence,*").set("DynamicImport-Package", "*").set("Bundle-SymbolicName", "Test-Kie-Spring-Bundle").build()).start()};
    }

    @BeforeClass
    public static void initialize() {
        tempDir = new File(System.getProperty("java.io.tmpdir"));
        testDir = new File(tempDir, "test_dir");
        String fileName = "test_file_" + CamelWorkitemIntegrationTest.class.getName() + "_" + UUID.randomUUID().toString();
        testFile = new File(tempDir, fileName);
    }

    @AfterClass
    public static void clean() throws IOException {
        FileUtils.deleteDirectory((File)testDir);
    }

    @Before
    public void prepare() {
        Assert.assertNotNull((Object)this.kieSession);
    }

    @Test
    public void testSingleFileProcess() throws IOException {
        String testData = "test-data";
        FileCamelWorkitemHandler handler = new FileCamelWorkitemHandler();
        this.kieSession.getWorkItemManager().registerWorkItemHandler("CamelFile", (WorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("payloadVar", "test-data");
        params.put("pathVar", tempDir.getAbsolutePath());
        params.put("fileNameVar", testFile.getName());
        ProcessInstance pi = this.kieSession.startProcess("camelFileProcess", params);
        ProcessInstance result = this.kieSession.getProcessInstance(pi.getId());
        Assert.assertTrue((boolean)testFile.exists());
        String resultText = FileUtils.readFileToString((File)testFile);
        Assert.assertEquals((Object)"test-data", (Object)resultText);
    }

    @Test
    public void testSingleFileWithHeaders() throws IOException {
        HashSet<String> headers = new HashSet<String>();
        headers.add("CamelFileName");
        FileCamelWorkitemHandler handler = new FileCamelWorkitemHandler(headers);
        String testData = "test-data";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("path", (Object)tempDir.getAbsolutePath());
        workItem.setParameter("payload", (Object)"test-data");
        workItem.setParameter("CamelFileName", (Object)testFile.getName());
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertTrue((boolean)testFile.exists());
        String resultText = FileUtils.readFileToString((File)testFile);
        Assert.assertEquals((Object)"test-data", (Object)resultText);
    }
}

