/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.okta;

import com.okta.sdk.client.Client;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.okta.OktaAuth;
import org.jbpm.process.workitem.okta.model.OktaUser;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="OktaGetUsers.wid", name="OktaGetUsers", displayName="OktaGetUsers", defaultHandler="mvel: new org.jbpm.process.workitem.okta.GetUsersWorkitemHandler(\"apiToken\")", documentation="okta-workitem/index.html", category="okta-workitem", icon="OktaGetUsers.png", parameters={@WidParameter(name="UserIds")}, results={@WidResult(name="Users", runtimeType="java.util.List")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="okta-workitem", version="7.71.0.Final")}, serviceInfo=@WidService(category="Okta", description="Interact with Okta management API", keywords="okta,auth,users,get", action=@WidAction(title="Get users from Okta"), authinfo=@WidAuth(required=true, params={"apiToken"}, paramsdescription={"Okta api token"}, referencesite="https://developer.okta.com/")))
public class GetUsersWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private Client oktaClient;
    private OktaAuth auth = new OktaAuth();
    private static final String RESULTS_VALUE = "Users";

    public GetUsersWorkitemHandler() throws Exception {
        try {
            this.oktaClient = this.auth.authorize();
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with Okta: " + e.getMessage());
        }
    }

    public GetUsersWorkitemHandler(String apiToken) throws Exception {
        try {
            this.oktaClient = this.auth.authorize(apiToken);
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with Okta: " + e.getMessage());
        }
    }

    public GetUsersWorkitemHandler(Client oktaClient) {
        this.oktaClient = oktaClient;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String userids = (String)workItem.getParameter("UserIds");
            ArrayList retUserList = new ArrayList();
            UserList userList = this.oktaClient.listUsers();
            if (userids != null && userids.length() > 0) {
                List<String> useridsList = Arrays.asList(userids.split(","));
                userList.stream().filter(usr -> useridsList.contains(usr.getId())).forEach(usr -> retUserList.add(new OktaUser((User)usr)));
            } else {
                userList.stream().forEach(usr -> retUserList.add(new OktaUser((User)usr)));
            }
            HashMap results = new HashMap();
            results.put(RESULTS_VALUE, retUserList);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }
}

