/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.okta;

import com.okta.sdk.client.Client;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.okta.OktaAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="OktaCreateUser.wid", name="OktaCreateUser", displayName="OktaCreateUser", defaultHandler="mvel: new org.jbpm.process.workitem.okta.CreateUserWorkitemHandler(\"apiToken\")", documentation="okta-workitem/index.html", category="okta-workitem", icon="OktaCreateUser.png", parameters={@WidParameter(name="UserEmail", required=true), @WidParameter(name="UserFirstName", required=true), @WidParameter(name="UserLastName", required=true), @WidParameter(name="UserActive"), @WidParameter(name="UserGroupIds"), @WidParameter(name="UserLogin"), @WidParameter(name="UserPassword"), @WidParameter(name="UserSecurityQuestion"), @WidParameter(name="UserSecurityAnswer")}, results={@WidResult(name="UserId")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="okta-workitem", version="7.73.0.Final")}, serviceInfo=@WidService(category="Okta", description="Interact with Okta management API", keywords="okta,auth,user,create", action=@WidAction(title="Create new user to Okta"), authinfo=@WidAuth(required=true, params={"apiToken"}, paramsdescription={"Okta api token"}, referencesite="https://developer.okta.com/")))
public class CreateUserWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private Client oktaClient;
    private OktaAuth auth = new OktaAuth();
    private static final String RESULTS_VALUE = "UserId";

    public CreateUserWorkitemHandler() throws Exception {
        try {
            this.oktaClient = this.auth.authorize();
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with Okta: " + e.getMessage());
        }
    }

    public CreateUserWorkitemHandler(String apiToken) throws Exception {
        try {
            this.oktaClient = this.auth.authorize(apiToken);
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with Okta: " + e.getMessage());
        }
    }

    public CreateUserWorkitemHandler(Client oktaClient) {
        this.oktaClient = oktaClient;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String userEmail = (String)workItem.getParameter("UserEmail");
            String userFirstName = (String)workItem.getParameter("UserFirstName");
            String userLastName = (String)workItem.getParameter("UserLastName");
            String userActive = (String)workItem.getParameter("UserActive");
            String userGroupIds = (String)workItem.getParameter("UserGroupIds");
            String userLogin = (String)workItem.getParameter("UserLogin");
            String userPassword = (String)workItem.getParameter("UserPassword");
            String userSecurityQuestion = (String)workItem.getParameter("UserSecurityQuestion");
            String userSecurityAnswer = (String)workItem.getParameter("UserSecurityAnswer");
            UserBuilder userBuilder = UserBuilder.instance().setEmail(userEmail).setFirstName(userFirstName).setLastName(userLastName);
            if (userActive != null) {
                userBuilder = userBuilder.setActive(Boolean.valueOf(Boolean.parseBoolean(userActive)));
            }
            if (userGroupIds != null) {
                List<String> groupIdsList = Arrays.asList(userGroupIds.split(","));
                for (String grp : groupIdsList) {
                    userBuilder = userBuilder.addGroup(grp);
                }
            }
            if (userLogin != null) {
                userBuilder = userBuilder.setLogin(userLogin);
            }
            if (userPassword != null) {
                userBuilder = userBuilder.setPassword(userPassword.toCharArray());
            }
            if (userSecurityQuestion != null) {
                userBuilder = userBuilder.setSecurityQuestion(userSecurityQuestion);
            }
            if (userSecurityAnswer != null) {
                userBuilder = userBuilder.setSecurityQuestionAnswer(userSecurityAnswer);
            }
            User user = userBuilder.buildAndCreate(this.oktaClient);
            HashMap<String, String> results = new HashMap<String, String>();
            results.put(RESULTS_VALUE, user.getId());
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }
}

