/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.process.workitem.rss;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile = "RSSDefinitions.wid", name = "RSS",
        displayName = "RSS",
        defaultHandler = "mvel: new org.jbpm.process.workitem.rss.RSSWorkItemHandler()",
        documentation = "rss-workitem/index.html",
        category = "rss-workitem",
        icon = "RSS.png",
        parameters = {
                @WidParameter(name = "URL", required = true)
        },
        mavenDepends = {
                @WidMavenDepends(group = "org.jbpm.contrib", artifact = "rss-workitem", version = "7.63.0.Final")
        },
        serviceInfo = @WidService(category = "RSS", description = "Create RSS feeds",
                keywords = "rss,feed,create",
                action = @WidAction(title = "Create a RSS feed from multiple sources"),
                authinfo = @WidAuth
        ))
public class RSSWorkItemHandler extends AbstractLogOrThrowWorkItemHandler {

    private List<SyndFeed> feeds = new ArrayList<SyndFeed>();
    private SyndFeedInput input;

    public void executeWorkItem(WorkItem workItem,
                                WorkItemManager manager) {
        try {

            RequiredParameterValidator.validate(this.getClass(),
                                                workItem);

            List<String> urls = new ArrayList<String>();
            String urlsList = (String) workItem.getParameter("URL");

            for (String s : urlsList.split(";")) {
                if (s != null && !"".equals(s)) {
                    urls.add(s);
                }
            }

            for (String url : urls) {
                URL feedSource = new URL(url);
                if (input == null) {
                    input = new SyndFeedInput();
                }

                SyndFeed feed = input.build(new XmlReader(feedSource));
                feeds.add(feed);
            }

            manager.completeWorkItem(workItem.getId(),
                                     null);
        } catch (Exception ex) {
            handleException(ex);
        }
    }

    public List<SyndFeed> getFeeds() {
        return this.feeds;
    }

    public void abortWorkItem(WorkItem workItem,
                              WorkItemManager manager) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    // for testing
    public void setInput(SyndFeedInput input) {
        this.input = input;
    }
}
