/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.Reader;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.rss.RSSWorkItemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class RSSWorkItemHandlerTest {
    @Mock
    SyndFeedInput input;
    @Mock
    SyndFeed feed;

    @Test
    public void testAddFeed() throws Exception {
        Mockito.when((Object)this.input.build((Reader)Mockito.any(XmlReader.class))).thenReturn((Object)this.feed);
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("URL", (Object)"http://someurl.org");
        RSSWorkItemHandler handler = new RSSWorkItemHandler();
        handler.setInput(this.input);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testAddFeedInvalidParams() throws Exception {
        Mockito.when((Object)this.input.build((Reader)Mockito.any(XmlReader.class))).thenReturn((Object)this.feed);
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        RSSWorkItemHandler handler = new RSSWorkItemHandler();
        handler.setInput(this.input);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)0L, (long)manager.getResults().size());
    }
}

