/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.slack;

import com.github.seratch.jslack.Slack;
import com.github.seratch.jslack.api.methods.MethodsClient;
import com.github.seratch.jslack.api.methods.request.channels.ChannelsListRequest;
import com.github.seratch.jslack.api.methods.request.chat.ChatPostMessageRequest;
import com.github.seratch.jslack.api.methods.request.reminders.RemindersAddRequest;
import com.github.seratch.jslack.api.methods.response.channels.ChannelsListResponse;
import com.github.seratch.jslack.api.methods.response.chat.ChatPostMessageResponse;
import com.github.seratch.jslack.api.methods.response.reminders.RemindersAddResponse;
import com.github.seratch.jslack.api.model.Channel;
import java.util.ArrayList;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.slack.AddReminderWorkitemHandler;
import org.jbpm.process.workitem.slack.PostMessageToChannelWorkitemHandler;
import org.jbpm.process.workitem.slack.SlackAuth;
import org.jbpm.test.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SlackWorkitemHandlerTest
extends AbstractBaseTest {
    @Mock
    Slack slack;
    @Mock
    MethodsClient methods;
    @Mock
    ChannelsListResponse channelsListResponse;
    @Mock
    ChatPostMessageResponse chatPostMessageResponse;
    @Mock
    RemindersAddResponse remindersAddResponse;

    @Before
    public void setUp() {
        try {
            ArrayList<Channel> channelList = new ArrayList<Channel>();
            Channel testChannelOne = new Channel();
            testChannelOne.setName("testChannel1");
            testChannelOne.setId("testChannel1ID");
            Channel testChannelTwo = new Channel();
            testChannelTwo.setName("testChannel2");
            testChannelTwo.setId("testChannel2ID");
            channelList.add(testChannelOne);
            channelList.add(testChannelTwo);
            Mockito.when((Object)this.slack.methods()).thenReturn((Object)this.methods);
            Mockito.when((Object)this.methods.channelsList((ChannelsListRequest)Mockito.any())).thenReturn((Object)this.channelsListResponse);
            Mockito.when((Object)this.channelsListResponse.isOk()).thenReturn((Object)true);
            Mockito.when((Object)this.channelsListResponse.getChannels()).thenReturn(channelList);
            Mockito.when((Object)this.methods.chatPostMessage((ChatPostMessageRequest)Mockito.any())).thenReturn((Object)this.chatPostMessageResponse);
            Mockito.when((Object)this.chatPostMessageResponse.isOk()).thenReturn((Object)true);
            Mockito.when((Object)this.methods.remindersAdd((RemindersAddRequest)Mockito.any())).thenReturn((Object)this.remindersAddResponse);
            Mockito.when((Object)this.remindersAddResponse.isOk()).thenReturn((Object)true);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPostMessageToChannel() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ChannelName", (Object)"testChannel1");
        workItem.setParameter("Message", (Object)"testMessage");
        PostMessageToChannelWorkitemHandler handler = new PostMessageToChannelWorkitemHandler("testAccessToken");
        SlackAuth auth = new SlackAuth();
        auth.setSlack(this.slack);
        handler.setAuth(auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testAddReminder() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ReminderText", (Object)"this is a test reminder");
        workItem.setParameter("ReminderTime", (Object)"in 10 minutes");
        AddReminderWorkitemHandler handler = new AddReminderWorkitemHandler("testAccessToken");
        SlackAuth auth = new SlackAuth();
        auth.setSlack(this.slack);
        handler.setAuth(auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }
}

