/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.slack;

import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.slack.SlackAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="SlackAddReminderDefinitions.wid", name="SlackAddReminder", displayName="SlackAddReminder", defaultHandler="mvel: new org.jbpm.process.workitem.slack.AddReminderWorkitemHandler(\"accessToken\")", documentation="slack-workitem/index.html", category="slack-workitem", icon="SlackAddReminder.png", parameters={@WidParameter(name="ReminderText", required=true), @WidParameter(name="ReminderTime", required=true)}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="slack-workitem", version="7.65.0.Final")}, serviceInfo=@WidService(category="Slack", description="Post messages and add reminders using Slack", keywords="slack,reminder,remind,send,message", action=@WidAction(title="Add a reminder to Slack"), authinfo=@WidAuth(required=true, params={"accessToken"}, paramsdescription={"Slack access token"}, referencesite="https://api.slack.com/tokens")))
public class AddReminderWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String accessToken;
    private SlackAuth auth = new SlackAuth();

    public AddReminderWorkitemHandler(String accessToken) {
        this.accessToken = accessToken;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            String reminderText = (String)workItem.getParameter("ReminderText");
            String reminderTime = (String)workItem.getParameter("ReminderTime");
            this.auth.authAddReminderRequest(this.accessToken, reminderText, reminderTime);
            workItemManager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(SlackAuth auth) {
        this.auth = auth;
    }
}

