/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.vimeo;

import com.clickntap.vimeo.Vimeo;
import com.clickntap.vimeo.VimeoResponse;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="DeleteVimeoDefinitions.wid", name="DeleteVimeo", displayName="DeleteVimeo", defaultHandler="mvel: new org.jbpm.process.workitem.vimeo.DeleteVideoWorkitemHandler(\"accessToken\")", documentation="vimeo-workitem/index.html", category="vimeo-workitem", icon="DeleteVimeo.png", parameters={@WidParameter(name="VideoEndpoint", required=true)}, results={@WidResult(name="ResponseStatusCode", runtimeType="java.lang.Integer")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="vimeo-workitem", version="7.19.0.Final")}, serviceInfo=@WidService(category="Vimeo", description="Interact with videos on Vimeo", keywords="vimeo,video,delete", action=@WidAction(title="Delete an existing video"), authinfo=@WidAuth(required=true, params={"accessToken"}, paramsdescription={"Vimeo access token"}, referencesite="https://developer.vimeo.com/api/authentication")))
public class DeleteVideoWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String accessToken;
    public static final String RESULT = "ResponseStatusCode";

    public DeleteVideoWorkitemHandler(String accessToken) {
        this.accessToken = accessToken;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String videoEndPoint = (String)workItem.getParameter("VideoEndpoint");
            Vimeo vimeo = (Vimeo)workItem.getParameter("Vimeo");
            HashMap<String, Integer> results = new HashMap<String, Integer>();
            if (vimeo == null) {
                vimeo = new Vimeo(this.accessToken);
            }
            VimeoResponse vimeoResponse = vimeo.removeVideo(videoEndPoint);
            results.put(RESULT, vimeoResponse.getStatusCode());
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }
}

