/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.vimeo;

import com.clickntap.vimeo.Vimeo;
import java.io.File;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="UploadVimeoDefinitions.wid", name="UploadVimeo", displayName="UploadVimeo", defaultHandler="mvel: new org.jbpm.process.workitem.vimeo.UploadVideoWorkitemHandler(\"accessToken\")", documentation="vimeo-workitem/index.html", category="vimeo-workitem", icon="UploadVimeo.png", parameters={@WidParameter(name="VideoFile", required=true, runtimeType="java.io.File")}, results={@WidResult(name="VideoEndpoint")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="vimeo-workitem", version="7.53.0.Final")}, serviceInfo=@WidService(category="Vimeo", description="Interact with videos on Vimeo", keywords="vimeo,video,upload,new", action=@WidAction(title="Upload new video on Vimeo"), authinfo=@WidAuth(required=true, params={"accessToken"}, paramsdescription={"Vimeo access token"}, referencesite="https://developer.vimeo.com/api/authentication")))
public class UploadVideoWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String accessToken;
    public static final String RESULT = "VideoEndpoint";

    public UploadVideoWorkitemHandler(String accessToken) {
        this.accessToken = accessToken;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            File videoFile = (File)workItem.getParameter("VideoFile");
            Vimeo vimeo = (Vimeo)workItem.getParameter("Vimeo");
            HashMap<String, String> results = new HashMap<String, String>();
            if (vimeo == null) {
                vimeo = new Vimeo(this.accessToken);
            }
            results.put(RESULT, vimeo.addVideo(videoFile, true));
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }
}

