/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Event;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.executor.annotations.Cancelled;
import org.jbpm.executor.annotations.Pending;
import org.jbpm.executor.api.CommandContext;
import org.jbpm.executor.api.Executor;
import org.jbpm.executor.api.ExecutorQueryService;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.entities.STATUS;
import org.jbpm.executor.impl.ExecutorRunnable;

@Transactional
public class ExecutorImpl
implements Executor {
    @Inject
    private Logger logger;
    @Inject
    private EntityManager em;
    @Inject
    private ExecutorRunnable task;
    @Inject
    private Event<RequestInfo> requestEvents;
    @Inject
    private ExecutorQueryService queryService;
    private ScheduledFuture<?> handle;
    private int threadPoolSize = 1;
    private int retries = 3;
    private int interval = 3;
    private ScheduledExecutorService scheduler;

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(int interval) {
        this.interval = interval;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public void setRetries(int retries) {
        this.retries = retries;
    }

    @Override
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Override
    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    @Override
    public void init() {
        this.logger.log(Level.INFO, " >>> Starting Executor Component ...\n \t - Thread Pool Size: {0}\n \t - Interval: {1} Seconds\n \t - Retries per Request: {2}\n", new Object[]{this.threadPoolSize, this.interval, this.retries});
        this.scheduler = Executors.newScheduledThreadPool(this.threadPoolSize);
        this.handle = this.scheduler.scheduleAtFixedRate(this.task, 2L, this.interval, TimeUnit.SECONDS);
    }

    @Override
    public Long scheduleRequest(String commandId, CommandContext ctx) {
        return this.scheduleRequest(commandId, new Date(), ctx);
    }

    @Override
    public Long scheduleRequest(String commandId, Date date, CommandContext ctx) {
        if (ctx == null) {
            throw new IllegalStateException("A Context Must Be Provided! ");
        }
        String businessKey = (String)ctx.getData("businessKey");
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setCommandName(commandId);
        requestInfo.setKey(businessKey);
        requestInfo.setStatus(STATUS.QUEUED);
        requestInfo.setTime(date);
        requestInfo.setMessage("Ready to execute");
        if (ctx.getData("retries") != null) {
            requestInfo.setRetries((Integer)ctx.getData("retries"));
        } else {
            requestInfo.setRetries(this.retries);
        }
        if (ctx != null) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream oout = new ObjectOutputStream(bout);
                oout.writeObject(ctx);
                requestInfo.setRequestData(bout.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
                requestInfo.setRequestData(null);
            }
        }
        this.em.persist((Object)requestInfo);
        this.requestEvents.select(new Annotation[]{new AnnotationLiteral<Pending>(){}}).fire((Object)requestInfo);
        this.logger.log(Level.INFO, " >>> Scheduling request for Command: {0} - requestId: {1} with {2} retries", new Object[]{commandId, requestInfo.getId(), requestInfo.getRetries()});
        return requestInfo.getId();
    }

    @Override
    public void cancelRequest(Long requestId) {
        this.logger.log(Level.INFO, " >>> Before - Cancelling Request with Id: {0}", requestId);
        List<RequestInfo> result = this.queryService.getPendingRequestById(requestId);
        if (result.isEmpty()) {
            return;
        }
        RequestInfo r = result.iterator().next();
        r.setStatus(STATUS.CANCELLED);
        this.em.merge((Object)r);
        this.requestEvents.select(new Annotation[]{new AnnotationLiteral<Cancelled>(){}}).fire((Object)r);
        this.logger.log(Level.INFO, " >>> After - Cancelling Request with Id: {0}", requestId);
    }

    @Override
    public void destroy() {
        this.logger.info(" >>>>> Destroying Executor !!!");
        this.handle.cancel(true);
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }
}

