/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.jbpm.executor.ExecutorServiceEntryPoint;
import org.jbpm.executor.api.CommandContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BasicExecutorBaseTest {
    @Inject
    protected ExecutorServiceEntryPoint executor;
    public static final Map<String, Object> cachedEntities = new HashMap<String, Object>();

    @Before
    public void setUp() {
        this.executor.setThreadPoolSize(1);
        this.executor.setInterval(3);
        this.executor.init();
    }

    @After
    public void tearDown() {
        this.executor.clearAllRequests();
        this.executor.clearAllErrors();
        this.executor.destroy();
    }

    @Test
    public void simpleExcecutionTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executor.scheduleRequest("PrintOutCmd", ctxCMD);
        Thread.sleep(10000L);
        List inErrorRequests = this.executor.getInErrorRequests();
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executor.getQueuedRequests();
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executor.getCompletedRequests();
        Assert.assertEquals((long)1L, (long)executedRequests.size());
    }

    @Test
    public void callbackTest() throws InterruptedException {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"SimpleIncrementCallback");
        this.executor.scheduleRequest("PrintOutCmd", commandContext);
        Thread.sleep(10000L);
        List inErrorRequests = this.executor.getInErrorRequests();
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executor.getQueuedRequests();
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executor.getCompletedRequests();
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        Assert.assertEquals((long)2L, (long)((AtomicLong)cachedEntities.get((String)commandContext.getData("businessKey"))).longValue());
    }

    @Test
    public void executorExceptionTest() throws InterruptedException {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"SimpleIncrementCallback");
        commandContext.setData("retries", (Object)0);
        this.executor.scheduleRequest("ThrowExceptionCmd", commandContext);
        System.out.println(System.currentTimeMillis() + "  >>> Sleeping for 10 secs");
        Thread.sleep(10000L);
        List inErrorRequests = this.executor.getInErrorRequests();
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        System.out.println("Error: " + inErrorRequests.get(0));
        List errors = this.executor.getAllErrors();
        System.out.println(" >>> Errors: " + errors);
        Assert.assertEquals((long)1L, (long)errors.size());
    }

    @Test
    public void defaultRequestRetryTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executor.scheduleRequest("ThrowExceptionCmd", ctxCMD);
        Thread.sleep(12000L);
        List inErrorRequests = this.executor.getInErrorRequests();
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        List errors = this.executor.getAllErrors();
        System.out.println(" >>> Errors: " + errors);
        Assert.assertEquals((long)4L, (long)errors.size());
    }

    @Test
    public void cancelRequestTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        Long requestId = this.executor.scheduleRequest("PrintOutCmd", ctxCMD);
        this.executor.cancelRequest(requestId);
        List cancelledRequests = this.executor.getCancelledRequests();
        Assert.assertEquals((long)1L, (long)cancelledRequests.size());
    }

    public void FIXMEfutureRequestTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        Long requestId = this.executor.scheduleRequest("PrintOutCmd", new Date(new Date().getTime() + 10000L), ctxCMD);
        Thread.sleep(5000L);
        List runningRequests = this.executor.getRunningRequests();
        Assert.assertEquals((long)0L, (long)runningRequests.size());
        List futureQueuedRequests = this.executor.getFutureQueuedRequests();
        Assert.assertEquals((long)1L, (long)futureQueuedRequests.size());
        Thread.sleep(10000L);
        List completedRequests = this.executor.getCompletedRequests();
        Assert.assertEquals((long)1L, (long)completedRequests.size());
    }
}

