/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.jbpm.executor.entities.ErrorInfo;
import org.jbpm.executor.entities.STATUS;

@Entity(name="RequestInfo")
public class RequestInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date time;
    @Enumerated(value=EnumType.STRING)
    private STATUS status;
    private String commandName;
    private String message;
    private String key;
    private int retries = 0;
    private int executions = 0;
    @Lob
    private byte[] requestData;
    @Lob
    private byte[] responseData;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="requestInfo")
    private List<ErrorInfo> errorInfo = new ArrayList<ErrorInfo>();

    public List<ErrorInfo> getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(List<ErrorInfo> errorInfo) {
        this.errorInfo = errorInfo;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getExecutions() {
        return this.executions;
    }

    public void setExecutions(int executions) {
        this.executions = executions;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void setStatus(STATUS status) {
        this.status = status;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public byte[] getRequestData() {
        return this.requestData;
    }

    public void setRequestData(byte[] requestData) {
        this.requestData = requestData;
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    public void setResponseData(byte[] responseData) {
        this.responseData = responseData;
    }

    public String toString() {
        return "RequestInfo{id=" + this.id + ", time=" + this.time + ", status=" + (Object)((Object)this.status) + ", commandName=" + this.commandName + ", message=" + this.message + ", key=" + this.key + ", requestData=" + this.requestData + ", responseData=" + this.responseData + ", error=" + this.errorInfo + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestInfo other = (RequestInfo)obj;
        if (!(this.id == other.id || this.id != null && this.id.equals(other.id))) {
            return false;
        }
        if (!(this.time == other.time || this.time != null && this.time.equals(other.time))) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        if (this.commandName == null ? other.commandName != null : !this.commandName.equals(other.commandName)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (!Arrays.equals(this.requestData, other.requestData)) {
            return false;
        }
        if (!Arrays.equals(this.responseData, other.responseData)) {
            return false;
        }
        return this.errorInfo == other.errorInfo || this.errorInfo != null && ((Object)this.errorInfo).equals(other.errorInfo);
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 79 * hash + (this.time != null ? this.time.hashCode() : 0);
        hash = 79 * hash + (this.status != null ? this.status.hashCode() : 0);
        hash = 79 * hash + (this.commandName != null ? this.commandName.hashCode() : 0);
        hash = 79 * hash + (this.message != null ? this.message.hashCode() : 0);
        hash = 79 * hash + (this.key != null ? this.key.hashCode() : 0);
        hash = 79 * hash + Arrays.hashCode(this.requestData);
        hash = 79 * hash + Arrays.hashCode(this.responseData);
        hash = 79 * hash + (this.errorInfo != null ? ((Object)this.errorInfo).hashCode() : 0);
        return hash;
    }
}

