/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.jbpm.executor.ExecutorServiceEntryPoint;
import org.jbpm.executor.api.CommandContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BasicExecutorBaseTest {
    @Inject
    protected ExecutorServiceEntryPoint executorService;
    public static final Map<String, Object> cachedEntities = new HashMap<String, Object>();

    @Before
    public void setUp() {
        this.executorService.setThreadPoolSize(1);
        this.executorService.setInterval(3);
        this.executorService.init();
    }

    @After
    public void tearDown() {
        this.executorService.clearAllRequests();
        this.executorService.clearAllErrors();
        this.executorService.destroy();
    }

    @Test
    public void simpleExcecutionTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", ctxCMD);
        Thread.sleep(10000L);
        List inErrorRequests = this.executorService.getInErrorRequests();
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests();
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests();
        Assert.assertEquals((long)1L, (long)executedRequests.size());
    }

    @Test
    public void callbackTest() throws InterruptedException {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"org.jbpm.executor.SimpleIncrementCallback");
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", commandContext);
        Thread.sleep(10000L);
        List inErrorRequests = this.executorService.getInErrorRequests();
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests();
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests();
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        Assert.assertEquals((long)2L, (long)((AtomicLong)cachedEntities.get((String)commandContext.getData("businessKey"))).longValue());
    }

    @Test
    public void executorExceptionTest() throws InterruptedException {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"org.jbpm.executor.SimpleIncrementCallback");
        commandContext.setData("retries", (Object)0);
        this.executorService.scheduleRequest("org.jbpm.executor.ThrowExceptionCommand", commandContext);
        System.out.println(System.currentTimeMillis() + "  >>> Sleeping for 10 secs");
        Thread.sleep(10000L);
        List inErrorRequests = this.executorService.getInErrorRequests();
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        System.out.println("Error: " + inErrorRequests.get(0));
        List errors = this.executorService.getAllErrors();
        System.out.println(" >>> Errors: " + errors);
        Assert.assertEquals((long)1L, (long)errors.size());
    }

    @Test
    public void defaultRequestRetryTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.ThrowExceptionCommand", ctxCMD);
        Thread.sleep(12000L);
        List inErrorRequests = this.executorService.getInErrorRequests();
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        List errors = this.executorService.getAllErrors();
        System.out.println(" >>> Errors: " + errors);
        Assert.assertEquals((long)4L, (long)errors.size());
    }

    @Test
    public void cancelRequestTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", ctxCMD);
        this.executorService.cancelRequest(requestId);
        List cancelledRequests = this.executorService.getCancelledRequests();
        Assert.assertEquals((long)1L, (long)cancelledRequests.size());
    }

    public void FIXMEfutureRequestTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", new Date(new Date().getTime() + 10000L), ctxCMD);
        Thread.sleep(5000L);
        List runningRequests = this.executorService.getRunningRequests();
        Assert.assertEquals((long)0L, (long)runningRequests.size());
        List futureQueuedRequests = this.executorService.getFutureQueuedRequests();
        Assert.assertEquals((long)1L, (long)futureQueuedRequests.size());
        Thread.sleep(10000L);
        List completedRequests = this.executorService.getCompletedRequests();
        Assert.assertEquals((long)1L, (long)completedRequests.size());
    }
}

