/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import java.net.URI;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceUnit;
import org.kie.commons.io.FileSystemType;
import org.kie.commons.io.IOService;
import org.kie.commons.io.impl.IOServiceNio2WrapperImpl;

@ApplicationScoped
public class ExecutorDatabaseProducer {
    private IOService ioService = new IOServiceNio2WrapperImpl();
    private static final String ORIGIN_URL = "https://github.com/guvnorngtestuser1/jbpm-console-ng-playground.git";
    private EntityManagerFactory emf;

    @PersistenceUnit(unitName="org.jbpm.executor")
    @ApplicationScoped
    @Produces
    public EntityManagerFactory getEntityManagerFactory() {
        if (this.emf == null) {
            this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.executor");
        }
        return this.emf;
    }

    @Produces
    @ApplicationScoped
    public EntityManager getEntityManager() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        return em;
    }

    @ApplicationScoped
    public void commitAndClose(@Disposes EntityManager em) {
        try {
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Produces
    public Logger createLogger(InjectionPoint injectionPoint) {
        return Logger.getLogger(injectionPoint.getMember().getDeclaringClass().getName());
    }

    @Produces
    @Named(value="ioStrategy")
    public IOService prepareFileSystem() {
        try {
            String userName = "guvnorngtestuser1";
            String password = "test1234";
            URI fsURI = URI.create("git://jbpm-playground");
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("username", "guvnorngtestuser1");
            env.put("password", "test1234");
            env.put("origin", ORIGIN_URL);
            this.ioService.newFileSystem(fsURI, env, (FileSystemType)FileSystemType.Bootstrap.BOOTSTRAP_INSTANCE);
        }
        catch (Exception e) {
            System.out.println(">>>>>>>>>>>>>>>>>>> E " + e.getMessage());
        }
        return this.ioService;
    }
}

