/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mail;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.event.usertask.UserTaskInstanceDeadlineEventBody;
import org.kie.kogito.mail.MailInfo;

public class MailInfoTest {
    @Test
    public void testMailInfo() {
        HashMap<String, String> notification = new HashMap<String, String>();
        notification.put("subject", "${inputs.name}");
        notification.put("body", "My name for process ${inputs.processInstanceId} is ${inputs.name}");
        notification.put("from", "javierito");
        notification.put("toemails", "javierito@doesnotexist.com,fulanito@doesnotexist.com");
        notification.put("replyTo", "javierito@doesnotexist.com");
        MailInfo mailInfo = MailInfo.of((UserTaskInstanceDeadlineEventBody)UserTaskInstanceDeadlineEventBody.create().notification(notification).inputs(Map.of("name", "Javierito", "processInstanceId", "1")).build());
        Assertions.assertThat((String)mailInfo.subject()).isEqualTo("Javierito");
        Assertions.assertThat((String)mailInfo.body()).isEqualTo("My name for process 1 is Javierito");
        Assertions.assertThat((String)mailInfo.from()).isEqualTo("javierito");
        Assertions.assertThat((String)mailInfo.replyTo()).isEqualTo("javierito@doesnotexist.com");
        Assertions.assertThat((Object[])mailInfo.to()).containsExactly((Object[])new String[]{"javierito@doesnotexist.com", "fulanito@doesnotexist.com"});
    }
}

