/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.HashMap;
import java.util.Properties;
import org.drools.core.io.impl.ClassPathResource;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.audit.AbstractAuditLogServiceTest;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.CommandBasedAuditLogService;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;

public class CommandBasedAuditLogServiceTest
extends AbstractAuditLogServiceTest {
    private HashMap<String, Object> context;
    private KieSession session;
    private AuditLogService auditLogService;

    private KnowledgeBase createKnowledgeBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("ruleflow.rf"), ResourceType.DRF);
        kbuilder.add((Resource)new ClassPathResource("ruleflow2.rf"), ResourceType.DRF);
        kbuilder.add((Resource)new ClassPathResource("ruleflow3.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        KnowledgeBase kbase = this.createKnowledgeBase();
        Environment env = PersistenceUtil.createEnvironment(this.context);
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "org.jbpm.persistence.processinstance.JPAProcessInstanceManagerFactory");
        properties.put("drools.processSignalManagerFactory", "org.jbpm.persistence.processinstance.JPASignalManagerFactory");
        KieSessionConfiguration config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)properties);
        this.session = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)config, (Environment)env);
        AbstractAuditLogger dblogger = AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)this.session, null);
        Assert.assertNotNull((Object)dblogger);
        Assert.assertTrue((boolean)(dblogger instanceof JPAWorkingMemoryDbLogger));
        this.auditLogService = new CommandBasedAuditLogService((CommandExecutor)this.session);
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
        this.session.dispose();
        this.session = null;
        this.auditLogService = null;
    }

    @Test
    public void testLogger1() throws Exception {
        CommandBasedAuditLogServiceTest.runTestLogger1(this.session, this.auditLogService);
    }

    @Test
    public void testLogger2() {
        CommandBasedAuditLogServiceTest.runTestLogger2(this.session, this.auditLogService);
    }

    @Test
    public void testLogger3() {
        CommandBasedAuditLogServiceTest.runTestLogger3(this.session, this.auditLogService);
    }

    @Test
    public void testLogger4() throws Exception {
        CommandBasedAuditLogServiceTest.runTestLogger4(this.session, this.auditLogService);
    }

    @Test
    public void testLogger4LargeVariable() throws Exception {
        CommandBasedAuditLogServiceTest.runTestLogger4LargeVariable(this.session, this.auditLogService);
    }

    @Test
    public void testLogger5() throws Exception {
        CommandBasedAuditLogServiceTest.runTestLogger5(this.session, this.auditLogService);
    }
}

