/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseFactory;
import org.drools.core.SessionConfiguration;
import org.drools.core.StatefulSession;
import org.drools.core.WorkingMemory;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.rule.Package;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.WorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkingMemoryDbLoggerTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(WorkingMemoryDbLoggerTest.class);
    private HashMap<String, Object> context;
    private AuditLogService logService;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory"));
        this.logService = new JPAAuditLogService(env);
    }

    @After
    public void tearDown() throws Exception {
        BitronixTransactionManager txm = TransactionManagerServices.getTransactionManager();
        Assert.assertTrue((String)"There is still a transaction running!", (txm.getCurrentTransaction() == null ? 1 : 0) != 0);
        PersistenceUtil.cleanUp(this.context);
        this.logService.dispose();
    }

    @Test
    public void testLogger1() {
        RuleBase ruleBase = WorkingMemoryDbLoggerTest.createKnowledgeBase();
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory");
        properties.put("drools.processSignalManagerFactory", "org.jbpm.process.instance.event.DefaultSignalManagerFactory");
        SessionConfiguration config = new SessionConfiguration(properties);
        StatefulSession session = ruleBase.newStatefulSession(config, PersistenceUtil.createEnvironment(this.context));
        new JPAWorkingMemoryDbLogger((WorkingMemory)session);
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        long processInstanceId = session.startProcess("com.sample.ruleflow").getId();
        logger.info("Checking process instances for process 'com.sample.ruleflow'");
        List processInstances = this.logService.findProcessInstances("com.sample.ruleflow");
        Assert.assertEquals((long)1L, (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(0);
        logger.info("{}", (Object)processInstance);
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)"com.sample.ruleflow", (Object)processInstance.getProcessId());
        List nodeInstances = this.logService.findNodeInstances(processInstanceId);
        Assert.assertEquals((long)6L, (long)nodeInstances.size());
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            logger.info("{}", (Object)nodeInstance);
            Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
            Assert.assertEquals((Object)"com.sample.ruleflow", (Object)processInstance.getProcessId());
            Assert.assertNotNull((Object)nodeInstance.getDate());
        }
        this.logService.clear();
    }

    @Test
    public void testLogger2() {
        RuleBase ruleBase = WorkingMemoryDbLoggerTest.createKnowledgeBase();
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory");
        properties.put("drools.processSignalManagerFactory", "org.jbpm.process.instance.event.DefaultSignalManagerFactory");
        SessionConfiguration config = new SessionConfiguration(properties);
        StatefulSession session = ruleBase.newStatefulSession(config, PersistenceUtil.createEnvironment(this.context));
        new JPAWorkingMemoryDbLogger((WorkingMemory)session);
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        session.startProcess("com.sample.ruleflow");
        session.startProcess("com.sample.ruleflow");
        logger.info("Checking process instances for process 'com.sample.ruleflow'");
        List processInstances = this.logService.findProcessInstances("com.sample.ruleflow");
        Assert.assertEquals((long)2L, (long)processInstances.size());
        for (ProcessInstanceLog processInstance : processInstances) {
            logger.info("{}", (Object)processInstance);
            logger.info(" -> {} - {}", (Object)processInstance.getStart(), (Object)processInstance.getEnd());
            List nodeInstances = this.logService.findNodeInstances(processInstance.getProcessInstanceId());
            for (NodeInstanceLog nodeInstance : nodeInstances) {
                logger.info("{}", (Object)nodeInstance);
                logger.info(" -> {}", (Object)nodeInstance.getDate());
            }
            Assert.assertEquals((long)6L, (long)nodeInstances.size());
        }
        this.logService.clear();
    }

    @Test
    public void testLogger3() {
        RuleBase ruleBase = WorkingMemoryDbLoggerTest.createKnowledgeBase();
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory");
        properties.put("drools.processSignalManagerFactory", "org.jbpm.process.instance.event.DefaultSignalManagerFactory");
        SessionConfiguration config = new SessionConfiguration(properties);
        StatefulSession session = ruleBase.newStatefulSession(config, PersistenceUtil.createEnvironment(this.context));
        new JPAWorkingMemoryDbLogger((WorkingMemory)session);
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        long processInstanceId = session.startProcess("com.sample.ruleflow2").getId();
        logger.info("Checking process instances for process 'com.sample.ruleflow2'");
        List processInstances = this.logService.findProcessInstances("com.sample.ruleflow2");
        Assert.assertEquals((long)1L, (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(0);
        logger.info("{}", (Object)processInstance);
        logger.info(" -> {} - {} ", (Object)processInstance.getStart(), (Object)processInstance.getEnd());
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)"com.sample.ruleflow2", (Object)processInstance.getProcessId());
        List nodeInstances = this.logService.findNodeInstances(processInstanceId);
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            logger.info("{}", (Object)nodeInstance);
            logger.info(" -> {}", (Object)nodeInstance.getDate());
            Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
            Assert.assertEquals((Object)"com.sample.ruleflow2", (Object)processInstance.getProcessId());
            Assert.assertNotNull((Object)nodeInstance.getDate());
        }
        Assert.assertEquals((long)14L, (long)nodeInstances.size());
        this.logService.clear();
    }

    private static RuleBase createKnowledgeBase() {
        PackageBuilder builder = new PackageBuilder();
        InputStreamReader source = new InputStreamReader(WorkingMemoryDbLoggerTest.class.getResourceAsStream("/ruleflow.rf"));
        builder.addProcessFromXml((Reader)source);
        source = new InputStreamReader(WorkingMemoryDbLoggerTest.class.getResourceAsStream("/ruleflow2.rf"));
        builder.addProcessFromXml((Reader)source);
        source = new InputStreamReader(WorkingMemoryDbLoggerTest.class.getResourceAsStream("/ruleflow3.rf"));
        builder.addProcessFromXml((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        return ruleBase;
    }
}

