/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.command;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.command.AuditCommand;
import org.kie.api.runtime.Context;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class FindProcessInstancesCommand
extends AuditCommand<List<ProcessInstanceLog>> {
    private static final long serialVersionUID = 8153962391271874232L;
    @XmlAttribute
    @XmlSchemaType(name="string")
    private String processId;

    public FindProcessInstancesCommand() {
        this.processId = null;
    }

    public FindProcessInstancesCommand(String processId) {
        this.processId = processId;
        if (processId == null || processId.isEmpty()) {
            throw new IllegalArgumentException("The processId field must not be null or empty.");
        }
    }

    public List<ProcessInstanceLog> execute(Context cntxt) {
        this.setLogEnvironment(cntxt);
        if (this.processId == null || this.processId.isEmpty()) {
            return this.auditLogService.findProcessInstances();
        }
        return this.auditLogService.findProcessInstances(this.processId);
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String toString() {
        if (this.processId == null || this.processId.isEmpty()) {
            return AuditLogService.class.getSimpleName() + ".findProcessInstances()";
        }
        return AuditLogService.class.getSimpleName() + ".findProcessInstances(" + this.processId + ")";
    }
}

