/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.query;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.audit.AuditLogServiceTest;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.strategy.StandaloneJtaStrategy;
import org.jbpm.process.instance.impl.util.LoggingPrintStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogDeleteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditDeleteTest
extends JPAAuditLogService {
    private static HashMap<String, Object> context;
    private static EntityManagerFactory emf;
    private static final Logger logger;
    private ProcessInstanceLog[] pilTestData;
    private VariableInstanceLog[] vilTestData;
    private NodeInstanceLog[] nilTestData;
    private boolean firstRun = true;
    private static Random random;

    @BeforeClass
    public static void configure() {
        LoggingPrintStream.interceptSysOutSysErr();
    }

    @AfterClass
    public static void reset() {
        LoggingPrintStream.resetInterceptSysOutSysErr();
    }

    @Before
    public void setUp() throws Exception {
        context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        emf = (EntityManagerFactory)context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        this.persistenceStrategy = new StandaloneJtaStrategy(emf);
        if (this.firstRun) {
            this.clearTables(ProcessInstanceLog.class, VariableInstanceLog.class, NodeInstanceLog.class);
            this.firstRun = false;
        }
        if (this.pilTestData == null) {
            this.pilTestData = this.createTestProcessInstanceLogData();
            this.vilTestData = this.createTestVariableInstanceLogData();
            this.nilTestData = this.createTestNodeInstanceLogData();
        }
    }

    @After
    public void cleanup() {
        this.clearTables(ProcessInstanceLog.class, VariableInstanceLog.class, NodeInstanceLog.class);
        PersistenceUtil.cleanUp(context);
    }

    private long randomLong() {
        long result = Math.abs(random.nextInt());
        while (result == 23L) {
            result = Math.abs(random.nextInt());
        }
        return result;
    }

    private String randomString() {
        return UUID.randomUUID().toString();
    }

    private Calendar randomCal() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.roll(6, -1 * random.nextInt(3650));
        cal.set(14, 0);
        cal.set(13, 0);
        return cal;
    }

    private ProcessInstanceLog[] createTestProcessInstanceLogData() {
        int i;
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        int numEntities = 11;
        ProcessInstanceLog[] testData = new ProcessInstanceLog[numEntities];
        Calendar cal = this.randomCal();
        for (i = 0; i < numEntities; ++i) {
            ProcessInstanceLog pil = new ProcessInstanceLog(this.randomLong(), this.randomString());
            pil.setDuration(Long.valueOf(this.randomLong()));
            pil.setExternalId(this.randomString());
            pil.setIdentity(this.randomString());
            pil.setOutcome(this.randomString());
            pil.setParentProcessInstanceId(this.randomLong());
            pil.setProcessId(this.randomString());
            pil.setProcessName(this.randomString());
            pil.setProcessVersion(this.randomString());
            pil.setStatus(random.nextInt());
            cal.add(12, 1);
            pil.setStart(cal.getTime());
            cal.add(6, 1);
            pil.setEnd(cal.getTime());
            testData[i] = pil;
        }
        block13: for (i = 0; i < numEntities; ++i) {
            switch (i) {
                case 1: {
                    testData[i - 1].setDuration(testData[i].getDuration());
                    continue block13;
                }
                case 2: {
                    testData[i - 1].setEnd(testData[i].getEnd());
                    continue block13;
                }
                case 3: {
                    testData[i - 1].setIdentity(testData[i].getIdentity());
                    continue block13;
                }
                case 4: {
                    testData[i - 1].setProcessId(testData[i].getProcessId());
                    continue block13;
                }
                case 5: {
                    testData[i - 1].setProcessInstanceId(testData[i].getProcessInstanceId().longValue());
                    continue block13;
                }
                case 6: {
                    testData[i - 1].setProcessName(testData[i].getProcessName());
                    continue block13;
                }
                case 7: {
                    testData[i - 1].setProcessVersion(testData[i].getProcessVersion());
                    continue block13;
                }
                case 8: {
                    testData[i - 1].setStart(testData[i].getStart());
                    continue block13;
                }
                case 9: {
                    testData[i - 1].setStatus(testData[i].getStatus().intValue());
                    continue block13;
                }
                case 10: {
                    testData[i - 1].setOutcome(testData[i].getOutcome());
                }
            }
        }
        Object tx = jtaHelper.joinTransaction(em);
        for (int i2 = 0; i2 < numEntities; ++i2) {
            em.persist((Object)testData[i2]);
        }
        jtaHelper.leaveTransaction(em, tx);
        return testData;
    }

    private NodeInstanceLog[] createTestNodeInstanceLogData() {
        int i;
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        int numEntities = 9;
        NodeInstanceLog[] testData = new NodeInstanceLog[numEntities];
        ProcessInstanceLog[] testDataPI = new ProcessInstanceLog[numEntities];
        Calendar cal = this.randomCal();
        for (i = 0; i < numEntities; ++i) {
            ProcessInstanceLog pLog;
            NodeInstanceLog nil = new NodeInstanceLog();
            nil.setProcessInstanceId(this.randomLong());
            nil.setProcessId(this.randomString());
            cal.add(13, 1);
            nil.setDate(cal.getTime());
            nil.setType(Math.abs(random.nextInt()));
            nil.setNodeInstanceId(this.randomString());
            nil.setNodeId(this.randomString());
            nil.setNodeName(this.randomString());
            nil.setNodeType(this.randomString());
            nil.setWorkItemId(Long.valueOf(this.randomLong()));
            nil.setConnection(this.randomString());
            nil.setExternalId(this.randomString());
            testData[i] = nil;
            testDataPI[i] = pLog = this.buildCompletedProcessInstance(nil.getProcessInstanceId());
        }
        block11: for (i = 0; i < numEntities; ++i) {
            switch (i) {
                case 1: {
                    testData[i - 1].setDate(testData[i].getDate());
                    continue block11;
                }
                case 2: {
                    testData[i - 1].setNodeId(testData[i].getNodeId());
                    continue block11;
                }
                case 3: {
                    testData[i - 1].setNodeInstanceId(testData[i].getNodeInstanceId());
                    continue block11;
                }
                case 4: {
                    testData[i - 1].setNodeName(testData[i].getNodeName());
                    continue block11;
                }
                case 5: {
                    testData[i - 1].setNodeType(testData[i].getNodeType());
                    continue block11;
                }
                case 6: {
                    testData[i - 1].setProcessId(testData[i].getProcessId());
                    continue block11;
                }
                case 7: {
                    testData[i - 1].setProcessInstanceId(testData[i].getProcessInstanceId().longValue());
                    continue block11;
                }
                case 8: {
                    testData[i - 1].setWorkItemId(testData[i].getWorkItemId());
                }
            }
        }
        Object tx = jtaHelper.joinTransaction(em);
        for (int i2 = 0; i2 < numEntities; ++i2) {
            em.persist((Object)testDataPI[i2]);
            em.persist((Object)testData[i2]);
        }
        jtaHelper.leaveTransaction(em, tx);
        return testData;
    }

    private VariableInstanceLog[] createTestVariableInstanceLogData() {
        int i;
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        int numEntities = 8;
        VariableInstanceLog[] testData = new VariableInstanceLog[numEntities];
        ProcessInstanceLog[] testDataPI = new ProcessInstanceLog[numEntities];
        Calendar cal = this.randomCal();
        for (i = 0; i < numEntities; ++i) {
            ProcessInstanceLog pLog;
            VariableInstanceLog vil = new VariableInstanceLog();
            vil.setProcessInstanceId(this.randomLong());
            vil.setProcessId(this.randomString());
            cal.add(12, 1);
            vil.setDate(cal.getTime());
            vil.setVariableInstanceId(this.randomString());
            vil.setVariableId(this.randomString());
            vil.setValue(this.randomString());
            vil.setOldValue(this.randomString());
            vil.setExternalId(this.randomString());
            testData[i] = vil;
            testDataPI[i] = pLog = this.buildCompletedProcessInstance(vil.getProcessInstanceId());
        }
        block10: for (i = 0; i < numEntities; ++i) {
            switch (i) {
                case 1: {
                    testData[i - 1].setDate(testData[i].getDate());
                    continue block10;
                }
                case 2: {
                    testData[i - 1].setOldValue(testData[i].getOldValue());
                    continue block10;
                }
                case 3: {
                    testData[i - 1].setProcessId(testData[i].getProcessId());
                    continue block10;
                }
                case 4: {
                    testData[i - 1].setProcessInstanceId(testData[i].getProcessInstanceId().longValue());
                    continue block10;
                }
                case 5: {
                    testData[i - 1].setValue(testData[i].getValue());
                    continue block10;
                }
                case 6: {
                    testData[i - 1].setVariableId(testData[i].getVariableId());
                    continue block10;
                }
                case 7: {
                    testData[i - 1].setVariableInstanceId(testData[i].getVariableInstanceId());
                }
            }
        }
        Object tx = jtaHelper.joinTransaction(em);
        for (int i2 = 0; i2 < numEntities; ++i2) {
            em.persist((Object)testDataPI[i2]);
            em.persist((Object)testData[i2]);
        }
        jtaHelper.leaveTransaction(em, tx);
        return testData;
    }

    private ProcessInstanceLog buildCompletedProcessInstance(long processInstanceId) {
        ProcessInstanceLog pil = new ProcessInstanceLog(processInstanceId, this.randomString());
        pil.setDuration(Long.valueOf(this.randomLong()));
        pil.setExternalId(this.randomString());
        pil.setIdentity(this.randomString());
        pil.setOutcome(this.randomString());
        pil.setParentProcessInstanceId(this.randomLong());
        pil.setProcessId(this.randomString());
        pil.setProcessName(this.randomString());
        pil.setProcessVersion(this.randomString());
        pil.setStatus(2);
        pil.setStart(null);
        pil.setEnd(null);
        return pil;
    }

    @Test
    public void testDeleteProcessInstanceInfoLogByProcessId() {
        int p = 0;
        String processId = this.pilTestData[p++].getProcessId();
        String processId2 = this.pilTestData[p++].getProcessId();
        ProcessInstanceLogDeleteBuilder updateBuilder = (ProcessInstanceLogDeleteBuilder)this.processInstanceLogDelete().processId(new String[]{processId, processId2});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)2L, (long)result);
    }

    @Test
    public void testDeleteProcessInstanceInfoLogByDate() {
        int p = 0;
        Date endDate = this.pilTestData[p++].getEnd();
        ProcessInstanceLogDeleteBuilder updateBuilder = this.processInstanceLogDelete().endDate(new Date[]{endDate});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testDeleteProcessInstanceInfoLogByTimestamp() {
        int p = 0;
        Date endDate = this.pilTestData[p++].getEnd();
        List logs = this.processInstanceLogQuery().endDate(new Date[]{endDate}).build().getResultList();
        Assert.assertEquals((long)1L, (long)logs.size());
        ProcessInstanceLogDeleteBuilder updateBuilder = this.processInstanceLogDelete().endDate(new Date[]{((org.kie.api.runtime.manager.audit.ProcessInstanceLog)logs.get(0)).getEnd()});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testDeleteProcessInstanceInfoLogByProcessIdAndDate() {
        int p = 0;
        String processId = this.pilTestData[p].getProcessId();
        Date endDate = this.pilTestData[p].getEnd();
        ProcessInstanceLogDeleteBuilder updateBuilder = (ProcessInstanceLogDeleteBuilder)this.processInstanceLogDelete().endDate(new Date[]{endDate}).processId(new String[]{processId});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testDeleteProcessInstanceInfoLogByProcessIdAndNotMatchingDate() {
        int p = 0;
        String processId = this.pilTestData[p++].getProcessId();
        Date endDate = this.pilTestData[p++].getEnd();
        ProcessInstanceLogDeleteBuilder updateBuilder = (ProcessInstanceLogDeleteBuilder)this.processInstanceLogDelete().endDate(new Date[]{endDate}).processId(new String[]{processId});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testDeleteProcessInstanceInfoLogByStatus() {
        int status = this.pilTestData[5].getStatus();
        ProcessInstanceLogDeleteBuilder updateBuilder = this.processInstanceLogDelete().status(new int[]{status});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testDeleteProcessInstanceInfoLogByDateRangeEnd() {
        Date endDate = this.pilTestData[4].getEnd();
        ProcessInstanceLogDeleteBuilder updateBuilder = this.processInstanceLogDelete().endDateRangeEnd(endDate);
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)5L, (long)result);
    }

    @Test
    public void testDeleteProcessInstanceInfoLogByDateRangeStart() {
        Date endDate = this.pilTestData[8].getEnd();
        ProcessInstanceLogDeleteBuilder updateBuilder = this.processInstanceLogDelete().endDateRangeStart(endDate);
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)3L, (long)result);
    }

    @Test
    public void testDeleteNodeInstanceInfoLogByProcessId() {
        int p = 0;
        String processId = this.nilTestData[p++].getProcessId();
        NodeInstanceLogDeleteBuilder updateBuilder = (NodeInstanceLogDeleteBuilder)this.nodeInstanceLogDelete().processId(new String[]{processId});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testDeleteNodeInstanceInfoLogByDate() {
        int p = 0;
        Date date = this.nilTestData[p++].getDate();
        NodeInstanceLogDeleteBuilder updateBuilder = (NodeInstanceLogDeleteBuilder)this.nodeInstanceLogDelete().date(new Date[]{date});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)2L, (long)result);
    }

    @Test
    public void testDeleteNodeInstanceInfoLogByDateRangeEnd() {
        Date endDate = this.nilTestData[4].getDate();
        NodeInstanceLogDeleteBuilder updateBuilder = (NodeInstanceLogDeleteBuilder)this.nodeInstanceLogDelete().dateRangeEnd(endDate);
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)5L, (long)result);
    }

    @Test
    public void testDeleteNodeInstanceInfoLogByTimestamp() {
        int p = 0;
        Date date = this.nilTestData[p++].getDate();
        List logs = this.nodeInstanceLogQuery().date(new Date[]{date}).build().getResultList();
        Assert.assertEquals((long)2L, (long)logs.size());
        NodeInstanceLogDeleteBuilder updateBuilder = (NodeInstanceLogDeleteBuilder)this.nodeInstanceLogDelete().date(new Date[]{((org.kie.api.runtime.manager.audit.NodeInstanceLog)logs.get(0)).getDate()});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)2L, (long)result);
    }

    @Test
    public void testDeleteVarInstanceInfoLogByProcessId() {
        int p = 0;
        String processId = this.vilTestData[p++].getProcessId();
        VariableInstanceLogDeleteBuilder updateBuilder = (VariableInstanceLogDeleteBuilder)this.variableInstanceLogDelete().processId(new String[]{processId});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testDeleteVarInstanceInfoLogByDate() {
        int p = 0;
        Date date = this.vilTestData[p++].getDate();
        VariableInstanceLogDeleteBuilder updateBuilder = (VariableInstanceLogDeleteBuilder)this.variableInstanceLogDelete().date(new Date[]{date});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)2L, (long)result);
    }

    @Test
    public void testDeleteVarInstanceInfoLogByDateRangeEnd() {
        Date endDate = this.vilTestData[4].getDate();
        VariableInstanceLogDeleteBuilder updateBuilder = (VariableInstanceLogDeleteBuilder)this.variableInstanceLogDelete().dateRangeEnd(endDate);
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)5L, (long)result);
    }

    @Test
    public void testDeleteVarInstanceInfoLogByTimestamp() {
        int p = 0;
        Date date = this.vilTestData[p++].getDate();
        List vars = this.variableInstanceLogQuery().date(new Date[]{date}).build().getResultList();
        Assert.assertEquals((long)2L, (long)vars.size());
        VariableInstanceLogDeleteBuilder updateBuilder = (VariableInstanceLogDeleteBuilder)this.variableInstanceLogDelete().date(new Date[]{((org.kie.api.runtime.manager.audit.VariableInstanceLog)vars.get(0)).getDate()});
        int result = updateBuilder.build().execute();
        Assert.assertEquals((long)2L, (long)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTables(Class<? extends Serializable> ... entities) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        try {
            for (Class<? extends Serializable> entity : entities) {
                em.createQuery("DELETE FROM " + entity.getSimpleName()).executeUpdate();
            }
        }
        finally {
            this.closeEntityManager(em, newTx);
        }
    }

    static {
        logger = LoggerFactory.getLogger(AuditLogServiceTest.class);
        random = new Random();
    }
}

