/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.query;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.audit.AuditQueryCriteriaUtil;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.JPAService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.query.jpa.data.QueryWhere;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditQueryCriteriaUtilTest {
    private static HashMap<String, Object> context;
    private static EntityManagerFactory emf;
    private static AuditQueryCriteriaUtil util;
    private static JPAAuditLogService auditLogService;
    private static final Logger logger;

    @BeforeClass
    public static void configure() {
        AbstractBaseTest.hackTheDatabaseMetadataLoggerBecauseTheresALogbackXmlInTheClasspath();
        context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        emf = (EntityManagerFactory)context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        auditLogService = new JPAAuditLogService(emf);
        util = new AuditQueryCriteriaUtil((JPAService)auditLogService);
    }

    @AfterClass
    public static void reset() {
        PersistenceUtil.cleanUp(context);
    }

    @Test
    public void auditQueryCriteriaWhereTest() {
        QueryWhere where = new QueryWhere();
        where.setToUnion();
        where.addParameter(QueryParameterIdentifiers.NODE_ID_LIST, (Object[])new String[]{"node.id"});
        where.addParameter(QueryParameterIdentifiers.NODE_INSTANCE_ID_LIST, (Object[])new String[]{"node-inst"});
        where.addParameter(QueryParameterIdentifiers.TYPE_LIST, (Object[])new String[]{"type"});
        where.newGroup();
        where.setToLike();
        where.addParameter(QueryParameterIdentifiers.NODE_NAME_LIST, (Object[])new String[]{"n*ends.X"});
        where.setToNormal();
        where.setToIntersection();
        where.addParameter(QueryParameterIdentifiers.TYPE_LIST, (Object[])new String[]{"oneOf3", "twoOf3", "thrOf3"});
        where.endGroup();
        where.setToIntersection();
        where.addRangeParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, (Object)0L, true);
        where.addRangeParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, (Object)10L, false);
        where.addParameter(QueryParameterIdentifiers.PROCESS_ID_LIST, (Object[])new String[]{"org.process.id"});
        List result = util.doCriteriaQuery(where, NodeInstanceLog.class);
        Assert.assertNotNull((String)"Null result from 1rst query.", (Object)result);
    }

    @Test
    public void auditQueryCriteriaMetaTest() {
        QueryWhere where = new QueryWhere();
        where.setAscending(QueryParameterIdentifiers.NODE_INSTANCE_ID_LIST);
        where.setCount(Integer.valueOf(10));
        where.setOffset(Integer.valueOf(2));
        List result = util.doCriteriaQuery(where, NodeInstanceLog.class);
        Assert.assertNotNull((String)"Null result from 1rst query.", (Object)result);
    }

    static {
        logger = LoggerFactory.getLogger(AuditQueryCriteriaUtilTest.class);
    }
}

