/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.AuditQueryCriteriaUtil;
import org.jbpm.process.audit.JPAService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.QueryHelper;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.query.NodeInstLogQueryBuilderImpl;
import org.jbpm.process.audit.query.NodeInstanceLogDeleteBuilderImpl;
import org.jbpm.process.audit.query.ProcInstLogQueryBuilderImpl;
import org.jbpm.process.audit.query.ProcessInstanceLogDeleteBuilderImpl;
import org.jbpm.process.audit.query.VarInstLogQueryBuilderImpl;
import org.jbpm.process.audit.query.VarInstanceLogDeleteBuilderImpl;
import org.jbpm.process.audit.strategy.PersistenceStrategyType;
import org.jbpm.query.jpa.data.QueryWhere;
import org.jbpm.query.jpa.impl.QueryCriteriaUtil;
import org.kie.api.runtime.Environment;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAAuditLogService
extends JPAService
implements AuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(JPAAuditLogService.class);
    private static final String AUDIT_LOG_PERSISTENCE_UNIT_NAME = "org.jbpm.persistence.jpa";
    private final AuditQueryCriteriaUtil queryUtil = new AuditQueryCriteriaUtil(this);

    public JPAAuditLogService() {
        super(AUDIT_LOG_PERSISTENCE_UNIT_NAME);
    }

    public JPAAuditLogService(Environment env) {
        super(env, AUDIT_LOG_PERSISTENCE_UNIT_NAME);
    }

    public JPAAuditLogService(Environment env, PersistenceStrategyType type) {
        super(env, type);
        this.persistenceUnitName = AUDIT_LOG_PERSISTENCE_UNIT_NAME;
    }

    public JPAAuditLogService(EntityManagerFactory emf) {
        super(emf);
        this.persistenceUnitName = AUDIT_LOG_PERSISTENCE_UNIT_NAME;
    }

    public JPAAuditLogService(EntityManagerFactory emf, PersistenceStrategyType type) {
        super(emf, type);
        this.persistenceUnitName = AUDIT_LOG_PERSISTENCE_UNIT_NAME;
    }

    @Override
    public List<ProcessInstanceLog> findProcessInstances() {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM ProcessInstanceLog");
        return this.executeQuery(query, em, ProcessInstanceLog.class);
    }

    @Override
    public List<ProcessInstanceLog> findActiveProcessInstances() {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM ProcessInstanceLog p WHERE p.end is null");
        return this.executeQuery(query, em, ProcessInstanceLog.class);
    }

    @Override
    public List<ProcessInstanceLog> findProcessInstances(String processId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId").setParameter("processId", (Object)processId);
        return this.executeQuery(query, em, ProcessInstanceLog.class);
    }

    @Override
    public List<ProcessInstanceLog> findActiveProcessInstances(String processId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId AND p.end is null").setParameter("processId", (Object)processId);
        return this.executeQuery(query, em, ProcessInstanceLog.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessInstanceLog findProcessInstance(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        try {
            ProcessInstanceLog processInstanceLog = (ProcessInstanceLog)em.createQuery("FROM ProcessInstanceLog p WHERE p.processInstanceId = :processInstanceId").setParameter("processInstanceId", (Object)processInstanceId).getSingleResult();
            return processInstanceLog;
        }
        catch (NoResultException e) {
            ProcessInstanceLog processInstanceLog = null;
            return processInstanceLog;
        }
        finally {
            this.closeEntityManager(em, newTx);
        }
    }

    @Override
    public List<ProcessInstanceLog> findSubProcessInstances(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM ProcessInstanceLog p WHERE p.parentProcessInstanceId = :processInstanceId").setParameter("processInstanceId", (Object)processInstanceId);
        return this.executeQuery(query, em, ProcessInstanceLog.class);
    }

    @Override
    public List<NodeInstanceLog> findNodeInstances(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId ORDER BY date,id").setParameter("processInstanceId", (Object)processInstanceId);
        return this.executeQuery(query, em, NodeInstanceLog.class);
    }

    @Override
    public List<NodeInstanceLog> findNodeInstances(long processInstanceId, String nodeId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId AND n.nodeId = :nodeId ORDER BY date,id").setParameter("processInstanceId", (Object)processInstanceId).setParameter("nodeId", (Object)nodeId);
        return this.executeQuery(query, em, NodeInstanceLog.class);
    }

    @Override
    public List<VariableInstanceLog> findVariableInstances(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId);
        return this.executeQuery(query, em, VariableInstanceLog.class);
    }

    @Override
    public List<VariableInstanceLog> findVariableInstances(long processInstanceId, String variableId) {
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId AND v.variableId = :variableId ORDER BY date,id").setParameter("processInstanceId", (Object)processInstanceId).setParameter("variableId", (Object)variableId);
        return this.executeQuery(query, em, VariableInstanceLog.class);
    }

    @Override
    public List<VariableInstanceLog> findVariableInstancesByName(String variableId, boolean onlyActiveProcesses) {
        EntityManager em = this.getEntityManager();
        Query query = !onlyActiveProcesses ? em.createQuery("FROM VariableInstanceLog v WHERE v.variableId = :variableId ORDER BY date") : em.createQuery("SELECT v FROM VariableInstanceLog v, ProcessInstanceLog p WHERE v.processInstanceId = p.processInstanceId AND v.variableId = :variableId AND p.end is null ORDER BY v.date");
        query.setParameter("variableId", (Object)variableId);
        return this.executeQuery(query, em, VariableInstanceLog.class);
    }

    @Override
    public List<VariableInstanceLog> findVariableInstancesByNameAndValue(String variableId, String value, boolean onlyActiveProcesses) {
        EntityManager em = this.getEntityManager();
        Query query = !onlyActiveProcesses ? em.createQuery("FROM VariableInstanceLog v WHERE v.variableId = :variableId AND v.value = :value ORDER BY date") : em.createQuery("SELECT v FROM VariableInstanceLog v, ProcessInstanceLog p WHERE v.processInstanceId = p.processInstanceId AND v.variableId = :variableId AND v.value = :value AND p.end is null ORDER BY v.date");
        query.setParameter("variableId", (Object)variableId).setParameter("value", (Object)value);
        return this.executeQuery(query, em, VariableInstanceLog.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        try {
            int deletedNodes = em.createQuery("delete FROM NodeInstanceLog WHERE processInstanceId in (select spl.processInstanceId FROM ProcessInstanceLog spl WHERE spl.status in (2, 3))").executeUpdate();
            logger.debug("CLEAR:: deleted node instances {}", (Object)deletedNodes);
            int deletedVariables = em.createQuery("delete FROM VariableInstanceLog WHERE processInstanceId in (select spl.processInstanceId FROM ProcessInstanceLog spl WHERE spl.status in (2, 3))").executeUpdate();
            logger.debug("CLEAR:: deleted variable instances {}", (Object)deletedVariables);
            int deletedProcesses = em.createQuery("delete FROM ProcessInstanceLog WHERE status in (2, 3)").executeUpdate();
            logger.debug("CLEAR:: deleted process instances {}", (Object)deletedProcesses);
        }
        finally {
            this.closeEntityManager(em, newTx);
        }
    }

    @Override
    public NodeInstanceLogQueryBuilder nodeInstanceLogQuery() {
        return new NodeInstLogQueryBuilderImpl(this);
    }

    @Override
    public VariableInstanceLogQueryBuilder variableInstanceLogQuery() {
        return new VarInstLogQueryBuilderImpl(this);
    }

    @Override
    public ProcessInstanceLogQueryBuilder processInstanceLogQuery() {
        return new ProcInstLogQueryBuilderImpl(this);
    }

    @Override
    public ProcessInstanceLogDeleteBuilder processInstanceLogDelete() {
        return new ProcessInstanceLogDeleteBuilderImpl(this);
    }

    @Override
    public NodeInstanceLogDeleteBuilder nodeInstanceLogDelete() {
        return new NodeInstanceLogDeleteBuilderImpl(this);
    }

    @Override
    public VariableInstanceLogDeleteBuilder variableInstanceLogDelete() {
        return new VarInstanceLogDeleteBuilderImpl(this);
    }

    @Override
    public <T, R> List<R> queryLogs(QueryWhere queryData, Class<T> queryClass, Class<R> resultClass) {
        List<T> results = this.doQuery(queryData, queryClass);
        return QueryCriteriaUtil.convertListToInterfaceList(results, resultClass);
    }

    protected QueryCriteriaUtil getQueryCriteriaUtil(Class<?> queryType) {
        return this.queryUtil;
    }

    public <T> List<T> doQuery(QueryWhere queryWhere, Class<T> queryType) {
        return this.getQueryCriteriaUtil(queryType).doCriteriaQuery(queryWhere, queryType);
    }

    protected static void addCriteria(String listId, String fieldName, Class<?> type) {
        QueryHelper.addCriteria(listId, fieldName, type);
    }

    public int doDelete(String queryTable, QueryWhere queryData, String subQuery, Map<String, Object> queryParams) {
        return this.executeQuery(QueryHelper.createQueryWithSubQuery(String.format("DELETE FROM %s l", queryTable), queryData, queryParams, subQuery).toSQL(), queryParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doPartialDelete(String queryTable, QueryWhere queryData, String subQuery, Map<String, Object> queryParams, int chunkSize) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        try {
            Query query = em.createQuery(QueryHelper.createQueryWithSubQuery(String.format("SELECT l.id FROM %s l", queryTable), queryData, queryParams, subQuery).toSQL());
            this.applyMetaQueryParameters(queryParams, query);
            IdConsumer consumer = new IdConsumer(queryTable, chunkSize);
            query.getResultStream().forEach(consumer);
            int n = consumer.getResult();
            return n;
        }
        finally {
            this.closeEntityManager(em, newTx);
        }
    }

    private int executeQuery(String queryString, Map<String, Object> queryParams) {
        logger.debug("DELETE statement:\n {}", (Object)queryString);
        if (logger.isDebugEnabled()) {
            StringBuilder paramsStr = new StringBuilder("PARAMS:");
            TreeMap<String, Object> orderedParams = new TreeMap<String, Object>(queryParams);
            for (Map.Entry entry : orderedParams.entrySet()) {
                paramsStr.append("\n " + (String)entry.getKey() + " : '" + entry.getValue() + "'");
            }
            logger.debug(paramsStr.toString());
        }
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        Query query = em.createQuery(queryString);
        int result = this.executeWithParameters(queryParams, query);
        logger.debug("Deleted rows {}", (Object)result);
        this.closeEntityManager(em, newTx);
        return result;
    }

    private void applyMetaQueryParameters(Map<String, Object> params, Query query) {
        if (params != null && !params.isEmpty()) {
            for (String name : params.keySet()) {
                Object paramVal = params.get(name);
                if (paramVal == null) continue;
                if ("firstResult".equals(name)) {
                    if ((Integer)paramVal <= 0) continue;
                    query.setFirstResult(((Integer)params.get(name)).intValue());
                    continue;
                }
                if ("maxResults".equals(name)) {
                    if ((Integer)paramVal <= 0) continue;
                    query.setMaxResults(((Integer)params.get(name)).intValue());
                    continue;
                }
                if ("flushMode".equals(name)) {
                    query.setFlushMode(FlushModeType.valueOf((String)((String)params.get(name))));
                    continue;
                }
                if ("orderType".equals(name) || "orderby".equals(name) || "filter".equals(name)) continue;
                query.setParameter(name, params.get(name));
            }
        }
    }

    private int executeWithParameters(Map<String, Object> params, Query query) {
        this.applyMetaQueryParameters(params, query);
        return query.executeUpdate();
    }

    static {
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "l.processInstanceId", Long.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.PROCESS_ID_LIST, "l.processId", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.WORK_ITEM_ID_LIST, "l.workItemId", Long.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.EXTERNAL_ID_LIST, "l.externalId", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.START_DATE_LIST, "l.start", Date.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.DURATION_LIST, "l.duration", Long.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.END_DATE_LIST, "l.end", Date.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.IDENTITY_LIST, "l.identity", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.PROCESS_NAME_LIST, "l.processName", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.PROCESS_VERSION_LIST, "l.processVersion", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.PROCESS_INSTANCE_STATUS_LIST, "l.status", Integer.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.OUTCOME_LIST, "l.outcome", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.CORRELATION_KEY_LIST, "l.correlationKey", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.NODE_ID_LIST, "l.nodeId", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.NODE_INSTANCE_ID_LIST, "l.nodeInstanceId", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.NODE_NAME_LIST, "l.nodeName", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.TYPE_LIST, "l.nodeType", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.DATE_LIST, "l.date", Date.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.OLD_VALUE_LIST, "l.oldValue", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.VALUE_LIST, "l.value", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.VARIABLE_ID_LIST, "l.variableId", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.VARIABLE_INSTANCE_ID_LIST, "l.variableInstanceId", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.CASE_FILE_DATA_LOG_LASTMODIFIED, "l.lastModified", Date.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.SUBQUERY_STATUS, "spl.status", Integer.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.SUBQUERY_DEPLOYMENT, "spl.externalId", String.class);
        JPAAuditLogService.addCriteria(QueryParameterIdentifiers.SUBQUERY_CASE, "spl.processId", String.class);
    }

    private class IdConsumer
    implements Consumer<Object> {
        private List<Object> ids = new ArrayList<Object>();
        private String query;
        private int chunkSize;
        private int result;

        public IdConsumer(String queryTable, int chunkSize) {
            this.query = String.format("DELETE FROM %s p WHERE p.id IN (:ids)", queryTable);
            this.chunkSize = chunkSize;
        }

        @Override
        public void accept(Object id) {
            this.ids.add(id);
            if (this.ids.size() >= this.chunkSize) {
                this.result += JPAAuditLogService.this.executeQuery(this.query, Collections.singletonMap("ids", this.ids));
                this.ids.clear();
            }
        }

        public int getResult() {
            if (!this.ids.isEmpty()) {
                this.result += JPAAuditLogService.this.executeQuery(this.query, Collections.singletonMap("ids", this.ids));
            }
            return this.result;
        }
    }
}

