/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.command;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.command.ClearHistoryLogsCommand;
import org.jbpm.process.audit.command.FindActiveProcessInstancesCommand;
import org.jbpm.process.audit.command.FindNodeInstancesCommand;
import org.jbpm.process.audit.command.FindProcessInstanceCommand;
import org.jbpm.process.audit.command.FindProcessInstancesCommand;
import org.jbpm.process.audit.command.FindSubProcessInstancesCommand;
import org.jbpm.process.audit.command.FindVariableInstancesCommand;
import org.junit.Test;
import org.kie.api.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationTest {
    private static final Logger log = LoggerFactory.getLogger(JPAAuditLogService.class);
    private static Class[] jaxbClasses = new Class[]{ClearHistoryLogsCommand.class, FindActiveProcessInstancesCommand.class, FindNodeInstancesCommand.class, FindProcessInstanceCommand.class, FindProcessInstancesCommand.class, FindSubProcessInstancesCommand.class, FindVariableInstancesCommand.class};

    public Object testRoundtrip(Object in) throws Exception {
        String xmlObject = SerializationTest.convertJaxbObjectToString(in);
        log.debug(xmlObject);
        return SerializationTest.convertStringToJaxbObject(xmlObject);
    }

    private static String convertJaxbObjectToString(Object object) throws JAXBException {
        Marshaller marshaller = JAXBContext.newInstance((Class[])jaxbClasses).createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal(object, (Writer)stringWriter);
        String output = stringWriter.toString();
        return output;
    }

    private static Object convertStringToJaxbObject(String xmlStr) throws JAXBException {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])jaxbClasses).createUnmarshaller();
        ByteArrayInputStream xmlStrInputStream = new ByteArrayInputStream(xmlStr.getBytes());
        Object jaxbObj = unmarshaller.unmarshal((InputStream)xmlStrInputStream);
        return jaxbObj;
    }

    @Test
    public void commandsTest() throws Exception {
        ArrayList<Object> cmds = new ArrayList<Object>();
        cmds.add(new ClearHistoryLogsCommand());
        cmds.add(new FindActiveProcessInstancesCommand("org.jbpm.test.jaxb"));
        cmds.add(new FindNodeInstancesCommand(23L, "node"));
        cmds.add(new FindNodeInstancesCommand(42L));
        cmds.add(new FindProcessInstanceCommand(125L));
        cmds.add(new FindProcessInstancesCommand("org.kie.serialization"));
        cmds.add(new FindProcessInstancesCommand());
        cmds.add(new FindSubProcessInstancesCommand(2048L));
        cmds.add(new FindVariableInstancesCommand(37L));
        cmds.add(new FindVariableInstancesCommand(74L, "mars"));
        for (Command command : cmds) {
            this.testRoundtrip(command);
        }
    }
}

