/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.process.audit.AbstractAuditLogServiceTest;
import org.jbpm.process.audit.AbstractWorkingMemoryDbLoggerTest;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Before;
import org.kie.api.KieBase;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;

public class WorkingMemoryDbLoggerWithSeparateLoggingEmfTest
extends AbstractWorkingMemoryDbLoggerTest {
    private KieSession ksession = null;
    private EntityManagerFactory emf;

    @Before
    public void beforeThis() {
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.logging.jta");
        this.logService = new JPAAuditLogService(this.emf);
    }

    @After
    public void afterThis() {
        if (this.emf != null && this.emf.isOpen()) {
            this.emf.close();
        }
        this.emf = null;
    }

    @Override
    public ProcessInstance startProcess(String processName) {
        if (this.ksession == null) {
            KieBase kbase = WorkingMemoryDbLoggerWithSeparateLoggingEmfTest.createKnowledgeBase();
            Environment env = PersistenceUtil.createEnvironment((Map)this.context);
            this.ksession = AbstractAuditLogServiceTest.createKieSession(kbase, env);
            this.ksession.addEventListener((ProcessEventListener)new JPAWorkingMemoryDbLogger(this.emf));
            this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        }
        return this.ksession.startProcess(processName);
    }
}

