/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidgetView;
import org.jbpm.designer.client.popup.AssignmentListItemWidgetView;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.shared.Variable;
import org.jbpm.designer.client.util.ListBoxValues;

@Dependent
public class ActivityDataIOEditorWidget
implements ActivityDataIOEditorWidgetView.Presenter {
    @Inject
    private ActivityDataIOEditorWidgetView view;
    ListBoxValues dataTypeListBoxValues;
    ListBoxValues processVarListBoxValues;
    Map<String, List<String>> customAssignmentsProperties;
    private Variable.VariableType variableType = Variable.VariableType.INPUT;
    boolean isSingleVar = false;
    private boolean allowDuplicateNames = true;
    private String duplicateNameErrorMessage = "";
    private Set<String> disallowedNames = new HashSet<String>();
    private String disallowedNameErrorMessage = "";
    List<AssignmentRow> hiddenPropertyRows = new ArrayList<AssignmentRow>();

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    @Override
    public void handleAddClick() {
        if (this.isSingleVar && this.view.getAssignmentRows().size() > 0) {
            this.view.showOnlySingleEntryAllowed();
        } else {
            this.addAssignment();
        }
    }

    public void setIsSingleVar(boolean isSingleVar) {
        this.isSingleVar = isSingleVar;
        if (this.variableType.equals((Object)Variable.VariableType.INPUT)) {
            this.view.setProcessVarAsSource();
            if (isSingleVar) {
                this.view.setTableTitleInputSingle();
            } else {
                this.view.setTableTitleInputMultiple();
            }
        } else {
            this.view.setProcessVarAsTarget();
            if (isSingleVar) {
                this.view.setTableTitleOutputSingle();
            } else {
                this.view.setTableTitleOutputMultiple();
            }
        }
    }

    public void setVariableType(Variable.VariableType variableType) {
        this.variableType = variableType;
    }

    public void setAllowDuplicateNames(boolean allowDuplicateNames, String duplicateNameErrorMessage) {
        this.allowDuplicateNames = allowDuplicateNames;
        this.duplicateNameErrorMessage = duplicateNameErrorMessage;
    }

    private boolean getShowConstants() {
        return this.variableType == Variable.VariableType.INPUT;
    }

    private void addAssignment() {
        List<AssignmentRow> as = this.view.getAssignmentRows();
        if (as.isEmpty()) {
            this.view.setTableDisplayStyle();
        }
        AssignmentRow newAssignment = new AssignmentRow();
        newAssignment.setVariableType(this.variableType);
        as.add(newAssignment);
        AssignmentListItemWidgetView widget = this.view.getAssignmentWidget(this.view.getAssignmentsCount() - 1);
        widget.setDataTypes(this.dataTypeListBoxValues);
        widget.setProcessVariables(this.processVarListBoxValues);
        widget.setShowConstants(this.getShowConstants());
        widget.setDisallowedNames(this.disallowedNames, this.disallowedNameErrorMessage);
        widget.setAllowDuplicateNames(this.allowDuplicateNames, this.duplicateNameErrorMessage);
        widget.setParentWidget(this);
    }

    public void removeAssignment(AssignmentRow assignmentRow) {
        this.view.getAssignmentRows().remove(assignmentRow);
        if (this.view.getAssignmentRows().isEmpty()) {
            this.view.setNoneDisplayStyle();
        }
    }

    public void setData(List<AssignmentRow> assignmentRows) {
        int i;
        this.hiddenPropertyRows.clear();
        if (this.disallowedNames != null && !this.disallowedNames.isEmpty()) {
            for (i = assignmentRows.size() - 1; i >= 0; --i) {
                AssignmentRow row = assignmentRows.get(i);
                if (row.getName() == null || row.getName().isEmpty() || !this.disallowedNames.contains(row.getName().toLowerCase())) continue;
                assignmentRows.remove(i);
                this.hiddenPropertyRows.add(0, row);
            }
        }
        if (assignmentRows.isEmpty()) {
            this.view.setNoneDisplayStyle();
        } else {
            this.view.setTableDisplayStyle();
        }
        this.view.setAssignmentRows(assignmentRows);
        for (i = 0; i < assignmentRows.size(); ++i) {
            this.view.getAssignmentWidget(i).setParentWidget(this);
            this.view.getAssignmentWidget(i).setDisallowedNames(this.disallowedNames, this.disallowedNameErrorMessage);
            this.view.getAssignmentWidget(i).setAllowDuplicateNames(this.allowDuplicateNames, this.duplicateNameErrorMessage);
        }
    }

    public List<AssignmentRow> getData() {
        ArrayList<AssignmentRow> rows = new ArrayList<AssignmentRow>();
        if (!this.view.getAssignmentRows().isEmpty()) {
            rows.addAll(this.view.getAssignmentRows());
        }
        if (!this.hiddenPropertyRows.isEmpty()) {
            rows.addAll(this.hiddenPropertyRows);
        }
        return rows;
    }

    public Variable.VariableType getVariableType() {
        return this.variableType;
    }

    public void setDataTypes(ListBoxValues dataTypeListBoxValues) {
        this.dataTypeListBoxValues = dataTypeListBoxValues;
        for (int i = 0; i < this.view.getAssignmentsCount(); ++i) {
            this.view.getAssignmentWidget(i).setDataTypes(dataTypeListBoxValues);
        }
    }

    public void setProcessVariables(ListBoxValues processVarListBoxValues) {
        this.processVarListBoxValues = processVarListBoxValues;
        for (int i = 0; i < this.view.getAssignmentsCount(); ++i) {
            AssignmentListItemWidgetView widget = this.view.getAssignmentWidget(i);
            widget.setProcessVariables(processVarListBoxValues);
            widget.setShowConstants(this.getShowConstants());
        }
    }

    public void setDisallowedNames(Set<String> disallowedNames, String disallowedNameErrorMessage) {
        this.disallowedNames = disallowedNames;
        this.disallowedNameErrorMessage = disallowedNameErrorMessage;
        for (int i = 0; i < this.view.getAssignmentsCount(); ++i) {
            this.view.getAssignmentWidget(i).setDisallowedNames(disallowedNames, disallowedNameErrorMessage);
        }
    }

    public void setCustomAssignmentsProperties(Map<String, List<String>> customAssignmentsProperties) {
        this.customAssignmentsProperties = customAssignmentsProperties;
        for (int i = 0; i < this.view.getAssignmentsCount(); ++i) {
            this.view.getAssignmentWidget(i).setCustomAssignmentsProperties(this.customAssignmentsProperties);
        }
    }

    public boolean isDuplicateName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        List<AssignmentRow> as = this.view.getAssignmentRows();
        if (as != null && !as.isEmpty()) {
            int nameCount = 0;
            for (AssignmentRow row : as) {
                if (name.trim().compareTo(row.getName()) != 0 || ++nameCount <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public void setIsVisible(boolean visible) {
        this.view.setVisible(visible);
    }

    public Widget getWidget() {
        return (Widget)this.view;
    }
}

