/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.ui.Composite;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.ValueListBox;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidget;
import org.jbpm.designer.client.popup.AssignmentListItemWidgetView;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.shared.Variable;
import org.jbpm.designer.client.shared.util.StringUtils;
import org.jbpm.designer.client.util.ComboBox;
import org.jbpm.designer.client.util.ComboBoxView;
import org.jbpm.designer.client.util.DataIOEditorNameTextBox;
import org.jbpm.designer.client.util.ListBoxValues;
import org.jbpm.designer.service.DesignerSpecific;
import org.uberfire.workbench.events.NotificationEvent;

@Templated(value="ActivityDataIOEditorWidget.html#assignment")
public class AssignmentListItemWidgetViewImpl
extends Composite
implements AssignmentListItemWidgetView,
ComboBoxView.ModelPresenter {
    @Inject
    @AutoBound
    protected DataBinder<AssignmentRow> assignment;
    @Inject
    @Bound
    @DataField
    @DesignerSpecific
    protected DataIOEditorNameTextBox name;
    protected ListBoxValues processVarListBoxValues;
    private boolean allowDuplicateNames = true;
    private String duplicateNameErrorMessage = "";
    @DataField
    protected ValueListBox<String> dataType = new ValueListBox((Renderer)new Renderer<String>(){

        public String render(String object) {
            String s = "";
            if (object != null) {
                s = object.toString();
            }
            return s;
        }

        public void render(String object, Appendable appendable) throws IOException {
            String s = this.render(object);
            appendable.append(s);
        }
    });
    @Inject
    @DataField
    protected TextBox customDataType;
    @DataField
    protected ValueListBox<String> processVar = new ValueListBox((Renderer)new Renderer<String>(){

        public String render(String object) {
            String s = "";
            if (object != null) {
                s = object.toString();
            }
            return s;
        }

        public void render(String object, Appendable appendable) throws IOException {
            String s = this.render(object);
            appendable.append(s);
        }
    });
    @Inject
    protected ComboBox dataTypeComboBox;
    @Inject
    ComboBox processVarComboBox;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    @DataField
    protected TextBox constant;
    @Inject
    @DataField
    protected Button deleteButton;
    private ActivityDataIOEditorWidget parentWidget;

    @Override
    public void setParentWidget(ActivityDataIOEditorWidget parentWidget) {
        this.parentWidget = parentWidget;
    }

    @Override
    public void setTextBoxModelValue(TextBox textBox, String value) {
        if (textBox == this.customDataType) {
            this.setCustomDataType(value);
        } else if (textBox == this.constant) {
            this.setConstant(value);
        }
    }

    @Override
    public void setListBoxModelValue(ValueListBox<String> listBox, String value) {
        if (listBox == this.dataType) {
            this.setDataType(value);
        } else if (listBox == this.processVar) {
            this.setProcessVar(value);
        }
    }

    @Override
    public String getModelValue(ValueListBox<String> listBox) {
        if (listBox == this.dataType) {
            String value = this.getCustomDataType();
            if (value == null || value.isEmpty()) {
                value = this.getDataType();
            }
            return value;
        }
        if (listBox == this.processVar) {
            String value = this.getConstant();
            if (value == null || value.isEmpty()) {
                value = this.getProcessVar();
            }
            return value;
        }
        return "";
    }

    @Override
    @PostConstruct
    public void init() {
        this.dataTypeComboBox.init(this, this.dataType, this.customDataType, false, AssignmentListItemWidgetView.CUSTOM_PROMPT, AssignmentListItemWidgetView.ENTER_TYPE_PROMPT);
        this.processVarComboBox.init(this, this.processVar, this.constant, true, AssignmentListItemWidgetView.CONSTANT_PROMPT, AssignmentListItemWidgetView.ENTER_CONSTANT_PROMPT);
        this.name.setRegExp("^[a-zA-Z0-9\\s\\.\\_]*$", DesignerEditorConstants.INSTANCE.Removed_invalid_characters_from_name(), DesignerEditorConstants.INSTANCE.Invalid_character_in_name());
        this.customDataType.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                int iChar = event.getNativeKeyCode();
                if (iChar == 32) {
                    event.preventDefault();
                }
            }
        });
        this.name.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                String value;
                if (!AssignmentListItemWidgetViewImpl.this.allowDuplicateNames && AssignmentListItemWidgetViewImpl.this.isDuplicateName(value = AssignmentListItemWidgetViewImpl.this.name.getText())) {
                    AssignmentListItemWidgetViewImpl.this.notification.fire((Object)new NotificationEvent(AssignmentListItemWidgetViewImpl.this.duplicateNameErrorMessage, NotificationEvent.NotificationType.ERROR));
                    AssignmentListItemWidgetViewImpl.this.name.setValue("");
                    ValueChangeEvent.fire((HasValueChangeHandlers)AssignmentListItemWidgetViewImpl.this.name, (Object)"");
                }
            }
        });
    }

    public AssignmentRow getModel() {
        return (AssignmentRow)this.assignment.getModel();
    }

    public void setModel(AssignmentRow model) {
        this.assignment.setModel((Object)model);
        this.initAssignmentControls();
    }

    @Override
    public Variable.VariableType getVariableType() {
        return this.getModel().getVariableType();
    }

    @Override
    public String getDataType() {
        return this.getModel().getDataType();
    }

    @Override
    public void setDataType(String dataType) {
        this.getModel().setDataType(dataType);
    }

    @Override
    public String getCustomDataType() {
        return this.getModel().getCustomDataType();
    }

    @Override
    public void setCustomDataType(String customDataType) {
        this.getModel().setCustomDataType(customDataType);
    }

    @Override
    public String getProcessVar() {
        return this.getModel().getProcessVar();
    }

    @Override
    public void setProcessVar(String processVar) {
        this.getModel().setProcessVar(processVar);
    }

    @Override
    public String getConstant() {
        return this.getModel().getConstant();
    }

    @Override
    public void setConstant(String constant) {
        this.getModel().setConstant(constant);
    }

    @Override
    public void setDataTypes(ListBoxValues dataTypeListBoxValues) {
        this.dataTypeComboBox.setCurrentTextValue("");
        this.dataTypeComboBox.setListBoxValues(dataTypeListBoxValues);
        this.dataTypeComboBox.setShowCustomValues(true);
        String cdt = this.getCustomDataType();
        if (cdt != null && !cdt.isEmpty()) {
            this.dataTypeComboBox.addCustomValueToListBoxValues(cdt, "");
        }
    }

    @Override
    public void setProcessVariables(ListBoxValues processVarListBoxValues) {
        this.processVarComboBox.setCurrentTextValue("");
        this.processVarListBoxValues = new ListBoxValues(processVarListBoxValues, false);
        this.processVarComboBox.setListBoxValues(this.processVarListBoxValues);
        String con = this.getConstant();
        if (con != null && !con.isEmpty()) {
            String displayValue = this.processVarComboBox.addCustomValueToListBoxValues(con, "");
            this.processVar.setValue((Object)displayValue);
        }
    }

    @Override
    public void setShowConstants(boolean showConstants) {
        this.processVarComboBox.setShowCustomValues(showConstants);
    }

    @Override
    public void setDisallowedNames(Set<String> disallowedNames, String disallowedNameErrorMessage) {
        this.name.setInvalidValues(disallowedNames, false, disallowedNameErrorMessage);
    }

    @Override
    public void setCustomAssignmentsProperties(Map<String, List<String>> customAssignmentsProperties) {
        String varName = this.name.getText();
        if (customAssignmentsProperties.get(varName) != null) {
            this.name.setReadOnly(true);
            List<String> customAssignmentValues = customAssignmentsProperties.get(varName);
            if (!customAssignmentValues.isEmpty()) {
                for (int i = customAssignmentValues.size() - 1; i >= 0; --i) {
                    this.processVarListBoxValues.addCustomValue(StringUtils.createQuotedConstant(customAssignmentValues.get(i)), null);
                }
            }
        }
    }

    @Override
    public void setAllowDuplicateNames(boolean allowDuplicateNames, String duplicateNameErrorMessage) {
        this.allowDuplicateNames = allowDuplicateNames;
        this.duplicateNameErrorMessage = duplicateNameErrorMessage;
    }

    @Override
    public boolean isDuplicateName(String name) {
        return this.parentWidget.isDuplicateName(name);
    }

    @EventHandler(value={"deleteButton"})
    public void handleDeleteButton(ClickEvent e) {
        this.parentWidget.removeAssignment(this.getModel());
    }

    private void initAssignmentControls() {
        String cdt;
        this.deleteButton.setIcon(IconType.TRASH);
        if (this.getVariableType() == Variable.VariableType.OUTPUT) {
            this.constant.setVisible(false);
        }
        if ((cdt = this.getCustomDataType()) != null && !cdt.isEmpty()) {
            this.customDataType.setValue((Object)cdt);
            this.dataType.setValue((Object)cdt);
        } else if (this.getDataType() != null) {
            this.dataType.setValue((Object)this.getDataType());
        }
        String con = this.getConstant();
        if (con != null && !con.isEmpty()) {
            this.constant.setValue((Object)con);
        } else if (this.getProcessVar() != null) {
            this.processVar.setValue((Object)this.getProcessVar());
        }
    }
}

