/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.util.HashMap;
import org.jbpm.runtime.manager.impl.deploy.MVELObjectModelResolver;
import org.jbpm.runtime.manager.impl.deploy.testobject.SimpleCustomObject;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.runtime.conf.ObjectModel;

public class MVELObjectModelResolverTest {
    @Test
    public void testSimpleNoArgObjectModel() {
        ObjectModel model = new ObjectModel("new org.jbpm.runtime.manager.impl.deploy.testobject.SimpleCustomObject()", new Object[0]);
        MVELObjectModelResolver resolver = new MVELObjectModelResolver();
        Object result = resolver.getInstance(model, this.getClass().getClassLoader(), new HashMap());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof SimpleCustomObject));
        Assert.assertEquals((Object)"default", (Object)((SimpleCustomObject)result).getName());
    }

    @Test
    public void testSimpleStaticObjectModel() {
        ObjectModel model = new ObjectModel("Integer.parseInt(\"10\")", new Object[0]);
        MVELObjectModelResolver resolver = new MVELObjectModelResolver();
        Object result = resolver.getInstance(model, this.getClass().getClassLoader(), new HashMap());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Integer));
        Assert.assertEquals((long)10L, (long)((Integer)result).intValue());
    }

    @Test
    public void testComplexStaticObjectModel() {
        ObjectModel model = new ObjectModel("String.valueOf(10).substring(1)", new Object[0]);
        MVELObjectModelResolver resolver = new MVELObjectModelResolver();
        Object result = resolver.getInstance(model, this.getClass().getClassLoader(), new HashMap());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof String));
        Assert.assertEquals((Object)"0", (Object)((String)result));
    }
}

