/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.util.HashMap;
import org.jbpm.runtime.manager.impl.deploy.ReflectionObjectModelResolver;
import org.jbpm.runtime.manager.impl.deploy.testobject.EmbedingCustomObject;
import org.jbpm.runtime.manager.impl.deploy.testobject.SimpleCustomObject;
import org.jbpm.runtime.manager.impl.deploy.testobject.ThirdLevelCustomObject;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;

public class ReflectionObjectModelResolverTest {
    @Test
    public void testSimpleNoArgObjectModel() {
        ObjectModel model = new ObjectModel("org.jbpm.runtime.manager.impl.deploy.testobject.SimpleCustomObject", new Object[0]);
        ReflectionObjectModelResolver resolver = new ReflectionObjectModelResolver();
        Object result = resolver.getInstance(model, this.getClass().getClassLoader(), new HashMap());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof SimpleCustomObject));
        Assert.assertEquals((Object)"default", (Object)((SimpleCustomObject)result).getName());
    }

    @Test
    public void testSimpleSingleStringArgObjectModel() {
        ObjectModel model = new ObjectModel("org.jbpm.runtime.manager.impl.deploy.testobject.SimpleCustomObject", new Object[]{"john"});
        ReflectionObjectModelResolver resolver = new ReflectionObjectModelResolver();
        Object result = resolver.getInstance(model, this.getClass().getClassLoader(), new HashMap());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof SimpleCustomObject));
        Assert.assertEquals((Object)"john", (Object)((SimpleCustomObject)result).getName());
    }

    @Test
    public void testSimpleSingleObjectArgObjectModel() {
        ObjectModel model = new ObjectModel("org.jbpm.runtime.manager.impl.deploy.testobject.EmbedingCustomObject", new Object[]{new ObjectModel("org.jbpm.runtime.manager.impl.deploy.testobject.SimpleCustomObject", new Object[]{"john"}), "testing object model"});
        ReflectionObjectModelResolver resolver = new ReflectionObjectModelResolver();
        Object result = resolver.getInstance(model, this.getClass().getClassLoader(), new HashMap());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof EmbedingCustomObject));
        Assert.assertEquals((Object)"testing object model", (Object)((EmbedingCustomObject)result).getDescription());
        SimpleCustomObject customObject = ((EmbedingCustomObject)result).getCustomObject();
        Assert.assertNotNull((Object)customObject);
        Assert.assertEquals((Object)"john", (Object)customObject.getName());
    }

    @Test
    public void testSimpleNestedObjectArgObjectModel() {
        ObjectModel model = new ObjectModel("org.jbpm.runtime.manager.impl.deploy.testobject.ThirdLevelCustomObject", new Object[]{new ObjectModel("org.jbpm.runtime.manager.impl.deploy.testobject.EmbedingCustomObject", new Object[]{new ObjectModel("org.jbpm.runtime.manager.impl.deploy.testobject.SimpleCustomObject", new Object[]{"john"}), "testing object model"})});
        ReflectionObjectModelResolver resolver = new ReflectionObjectModelResolver();
        Object result = resolver.getInstance(model, this.getClass().getClassLoader(), new HashMap());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof ThirdLevelCustomObject));
        Assert.assertEquals((Object)"testing object model", (Object)((ThirdLevelCustomObject)result).getEmbeddedObject().getDescription());
        SimpleCustomObject customObject = ((ThirdLevelCustomObject)result).getEmbeddedObject().getCustomObject();
        Assert.assertNotNull((Object)customObject);
        Assert.assertEquals((Object)"john", (Object)customObject.getName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSimpleNotExistingObjectModel() {
        ObjectModel model = new ObjectModel("org.jbpm.runtime.manager.impl.deploy.testobject.NotExistingObject", new Object[0]);
        ReflectionObjectModelResolver resolver = new ReflectionObjectModelResolver();
        resolver.getInstance(model, this.getClass().getClassLoader(), new HashMap());
    }

    @Test
    public void testSimpleContextValueObjectModel() {
        ObjectModel model = new ObjectModel("org.jbpm.runtime.manager.impl.deploy.testobject.SimpleCustomObject", new Object[]{"context"});
        ReflectionObjectModelResolver resolver = new ReflectionObjectModelResolver();
        HashMap<String, String> contextParam = new HashMap<String, String>();
        contextParam.put("context", "value from the context");
        Object result = resolver.getInstance(model, this.getClass().getClassLoader(), contextParam);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof SimpleCustomObject));
        Assert.assertEquals((Object)"value from the context", (Object)((SimpleCustomObject)result).getName());
    }

    @Test
    public void testSimpleNoArgNamedObjectModel() {
        NamedObjectModel model = new NamedObjectModel("CustomObject", "org.jbpm.runtime.manager.impl.deploy.testobject.SimpleCustomObject", new Object[0]);
        Assert.assertEquals((Object)"CustomObject", (Object)model.getName());
        ReflectionObjectModelResolver resolver = new ReflectionObjectModelResolver();
        Object result = resolver.getInstance((ObjectModel)model, this.getClass().getClassLoader(), new HashMap());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof SimpleCustomObject));
        Assert.assertEquals((Object)"default", (Object)((SimpleCustomObject)result).getName());
    }
}

