/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.lock;

import java.util.ServiceLoader;
import org.jbpm.runtime.manager.impl.lock.DefaultRuntimeManagerLockFactory;
import org.jbpm.runtime.manager.impl.lock.FreeRuntimeManagerLockStrategy;
import org.jbpm.runtime.manager.impl.lock.LegacyRuntimeManagerLockStrategy;
import org.jbpm.runtime.manager.spi.RuntimeManagerLockFactory;
import org.jbpm.runtime.manager.spi.RuntimeManagerLockStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeManagerLockStrategyFactory {
    protected static final Logger logger = LoggerFactory.getLogger(RuntimeManagerLockStrategyFactory.class);
    public String lockStrategyClassName;
    public String lockFactoryClassName;

    public RuntimeManagerLockStrategyFactory() {
        this(System.getProperty("org.kie.jbpm.runtime.manager.lock.strategy", LegacyRuntimeManagerLockStrategy.class.getName()), System.getProperty("org.kie.jbpm.runtime.manager.lock.factory", DefaultRuntimeManagerLockFactory.class.getName()));
    }

    public RuntimeManagerLockStrategyFactory(String strategy, String factory) {
        this.lockFactoryClassName = factory;
        this.lockStrategyClassName = strategy;
    }

    public RuntimeManagerLockStrategy createFreeLockStrategy() {
        return new FreeRuntimeManagerLockStrategy();
    }

    public RuntimeManagerLockStrategy createLockStrategy(String identifier) {
        RuntimeManagerLockStrategy runtimeManagerLockStrategy = null;
        ServiceLoader<RuntimeManagerLockStrategy> loader = ServiceLoader.load(RuntimeManagerLockStrategy.class);
        for (RuntimeManagerLockStrategy lockStrategy : loader) {
            if (!lockStrategy.getClass().getName().equals(this.lockStrategyClassName)) continue;
            runtimeManagerLockStrategy = lockStrategy;
            break;
        }
        if (runtimeManagerLockStrategy == null) {
            throw new RuntimeException("Could not find a proper RuntimeManagerLockStrategy for value " + this.lockStrategyClassName);
        }
        RuntimeManagerLockFactory runtimeManagerLockFactory = this.createRuntimeManagerLockFactory();
        runtimeManagerLockStrategy.init(runtimeManagerLockFactory);
        logger.info("RuntimeManagerLockStrategy {} with lock factory {} is created for {}", new Object[]{runtimeManagerLockStrategy.getClass().getName(), runtimeManagerLockFactory.getClass().getName(), identifier});
        return runtimeManagerLockStrategy;
    }

    private RuntimeManagerLockFactory createRuntimeManagerLockFactory() {
        RuntimeManagerLockFactory runtimeManagerLockFactory = null;
        ServiceLoader<RuntimeManagerLockFactory> loader = ServiceLoader.load(RuntimeManagerLockFactory.class);
        for (RuntimeManagerLockFactory currentRuntimeManagerLockFactory : loader) {
            if (!currentRuntimeManagerLockFactory.getClass().getName().equals(this.lockFactoryClassName)) continue;
            runtimeManagerLockFactory = currentRuntimeManagerLockFactory;
            break;
        }
        if (runtimeManagerLockFactory == null) {
            throw new RuntimeException("Could not find a proper RuntimeManagerLockFactory for value " + this.lockFactoryClassName);
        }
        return runtimeManagerLockFactory;
    }
}

