/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.cdi.test.hr;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jbpm.kie.services.impl.audit.ServicesAwareAuditEventBuilder;
import org.jbpm.kie.services.test.TestIdentityProvider;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.cdi.impl.manager.InjectableRegisterableItemsFactory;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.query.QueryContext;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.task.api.InternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Arquillian.class)
public class HumanResourcesHiringTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(HumanResourcesHiringTest.class);
    @Inject
    private EntityManagerFactory emf;
    @Inject
    private BeanManager beanManager;
    @Inject
    private RuntimeDataService runtimeDataService;
    @Inject
    private RuntimeManagerFactory managerFactory;

    @Deployment
    public static Archive<?> createDeployment() {
        return ((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"domain-services.jar")).addPackage("org.jbpm.services.task")).addPackage("org.jbpm.services.task.wih")).addPackage("org.jbpm.services.task.annotations")).addPackage("org.jbpm.services.task.api")).addPackage("org.jbpm.services.task.impl")).addPackage("org.jbpm.services.task.events")).addPackage("org.jbpm.services.task.exception")).addPackage("org.jbpm.services.task.identity")).addPackage("org.jbpm.services.task.factories")).addPackage("org.jbpm.services.task.internals")).addPackage("org.jbpm.services.task.internals.lifecycle")).addPackage("org.jbpm.services.task.lifecycle.listeners")).addPackage("org.jbpm.services.task.query")).addPackage("org.jbpm.services.task.util")).addPackage("org.jbpm.services.task.commands")).addPackage("org.jbpm.services.task.deadlines")).addPackage("org.jbpm.services.task.deadlines.notifications.impl")).addPackage("org.jbpm.services.task.subtask")).addPackage("org.jbpm.services.task.rule")).addPackage("org.jbpm.services.task.rule.impl")).addPackage("org.jbpm.services.task.audit.service")).addPackage("org.kie.internal.runtime.manager")).addPackage("org.kie.internal.runtime.manager.context")).addPackage("org.kie.internal.runtime.manager.cdi.qualifier")).addPackage("org.jbpm.runtime.manager.impl")).addPackage("org.jbpm.runtime.manager.impl.cdi")).addPackage("org.jbpm.runtime.manager.impl.factory")).addPackage("org.jbpm.runtime.manager.impl.jpa")).addPackage("org.jbpm.runtime.manager.impl.manager")).addPackage("org.jbpm.runtime.manager.impl.task")).addPackage("org.jbpm.runtime.manager.impl.tx")).addPackage("org.jbpm.shared.services.api")).addPackage("org.jbpm.shared.services.impl")).addPackage("org.jbpm.shared.services.impl.tx")).addPackage("org.jbpm.kie.services.api")).addPackage("org.jbpm.kie.services.impl")).addPackage("org.jbpm.kie.services.api.bpmn2")).addPackage("org.jbpm.kie.services.impl.bpmn2")).addPackage("org.jbpm.kie.services.impl.event.listeners")).addPackage("org.jbpm.kie.services.impl.audit")).addPackage("org.jbpm.kie.services.impl.form")).addPackage("org.jbpm.kie.services.impl.form.provider")).addPackage("org.jbpm.services.cdi")).addPackage("org.jbpm.services.cdi.impl")).addPackage("org.jbpm.services.cdi.impl.form")).addPackage("org.jbpm.services.cdi.impl.manager")).addPackage("org.jbpm.services.cdi.producer")).addPackage("org.jbpm.kie.services.test")).addPackage("org.jbpm.services.cdi.test")).addClass("org.jbpm.services.cdi.test.util.CDITestHelperNoTaskService")).addAsResource("jndi.properties", "jndi.properties")).addAsManifestResource("META-INF/persistence.xml", ArchivePaths.create((String)"persistence.xml"))).addAsManifestResource("META-INF/beans.xml", ArchivePaths.create((String)"beans.xml"));
    }

    @BeforeClass
    public static void setup() {
        TestUtil.cleanupSingletonSessionId();
    }

    protected void close() {
    }

    protected void configureServices() {
    }

    @Test
    public void simpleExecutionTest() {
        Assert.assertNotNull((Object)this.managerFactory);
        String id = "custom-manager";
        AbstractAuditLogger auditLogger = AuditLoggerFactory.newJPAInstance();
        ServicesAwareAuditEventBuilder auditEventBuilder = new ServicesAwareAuditEventBuilder();
        auditEventBuilder.setIdentityProvider((IdentityProvider)new TestIdentityProvider());
        auditEventBuilder.setDeploymentUnitId(id);
        auditLogger.setBuilder((AuditEventBuilder)auditEventBuilder);
        RuntimeEnvironmentBuilder builder = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).registerableItemsFactory(InjectableRegisterableItemsFactory.getFactory((BeanManager)this.beanManager, (AbstractAuditLogger)auditLogger));
        builder.addAsset(ResourceFactory.newClassPathResource((String)"repo/processes/hr/hiring.bpmn2"), ResourceType.BPMN2);
        RuntimeManager manager = this.managerFactory.newSingletonRuntimeManager(builder.get(), id);
        this.testHiringProcess(manager, EmptyContext.get());
        manager.close();
    }

    private void testHiringProcess(RuntimeManager manager, Context<?> context) {
        RuntimeEngine runtime = manager.getRuntimeEngine(context);
        KieSession ksession = runtime.getKieSession();
        TaskService taskService = runtime.getTaskService();
        Assert.assertNotNull((Object)runtime);
        Assert.assertNotNull((Object)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("EmailService", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                manager.completeWorkItem(workItem.getId(), null);
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        ksession.getWorkItemManager().registerWorkItemHandler("TwitterService", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                manager.completeWorkItem(workItem.getId(), null);
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        ProcessInstance processInstance = ksession.startProcess("hiring");
        Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstance.getId(), new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Collection completedNodes = this.runtimeDataService.getProcessInstanceHistoryCompleted(processInstance.getId(), new QueryContext());
        Assert.assertNotNull((Object)completedNodes);
        Assert.assertEquals((long)1L, (long)completedNodes.size());
        List tasks = ((InternalTaskService)taskService).getTasksAssignedByGroup("HR");
        TaskSummary HRInterview = (TaskSummary)tasks.get(0);
        taskService.claim(HRInterview.getId().longValue(), "katy");
        taskService.start(HRInterview.getId().longValue(), "katy");
        HashMap<String, Object> hrOutput = new HashMap<String, Object>();
        hrOutput.put("out_name", "salaboy");
        hrOutput.put("out_age", 29);
        hrOutput.put("out_mail", "salaboy@gmail.com");
        hrOutput.put("out_score", 8);
        taskService.complete(HRInterview.getId().longValue(), "katy", hrOutput);
        activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstance.getId(), new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        completedNodes = this.runtimeDataService.getProcessInstanceHistoryCompleted(processInstance.getId(), new QueryContext());
        Assert.assertNotNull((Object)completedNodes);
        Assert.assertEquals((long)2L, (long)completedNodes.size());
        Assert.assertNotNull((Object)processInstance);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        tasks = ((InternalTaskService)taskService).getTasksAssignedByGroup("IT");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary techInterview = (TaskSummary)tasks.get(0);
        Task techInterviewTask = taskService.getTaskById(techInterview.getId().longValue());
        Content contentById = taskService.getContentById(techInterviewTask.getTaskData().getDocumentContentId());
        Assert.assertNotNull((Object)contentById);
        Map taskContent = (Map)ContentMarshallerHelper.unmarshall((byte[])contentById.getContent(), null);
        Assert.assertEquals((long)7L, (long)taskContent.size());
        Assert.assertEquals((Object)"salaboy@gmail.com", taskContent.get("in_mail"));
        Assert.assertEquals((Object)29, taskContent.get("in_age"));
        Assert.assertEquals((Object)"salaboy", taskContent.get("in_name"));
        taskService.claim(techInterview.getId().longValue(), "salaboy");
        taskService.start(techInterview.getId().longValue(), "salaboy");
        HashMap<String, Object> techOutput = new HashMap<String, Object>();
        techOutput.put("out_skills", "java, jbpm, drools");
        techOutput.put("out_twitter", "@salaboy");
        techOutput.put("out_score", 8);
        taskService.complete(techInterview.getId().longValue(), "salaboy", techOutput);
        activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstance.getId(), new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        completedNodes = this.runtimeDataService.getProcessInstanceHistoryCompleted(processInstance.getId(), new QueryContext());
        Assert.assertNotNull((Object)completedNodes);
        Assert.assertEquals((long)3L, (long)completedNodes.size());
        tasks = ((InternalTaskService)taskService).getTasksAssignedByGroup("Accounting");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary createProposal = (TaskSummary)tasks.get(0);
        Task createProposalTask = taskService.getTaskById(createProposal.getId().longValue());
        contentById = taskService.getContentById(createProposalTask.getTaskData().getDocumentContentId());
        Assert.assertNotNull((Object)contentById);
        taskContent = (Map)ContentMarshallerHelper.unmarshall((byte[])contentById.getContent(), null);
        Assert.assertEquals((long)6L, (long)taskContent.size());
        Assert.assertEquals((Object)8, taskContent.get("in_tech_score"));
        Assert.assertEquals((Object)8, taskContent.get("in_hr_score"));
        taskService.claim(createProposal.getId().longValue(), "john");
        taskService.start(createProposal.getId().longValue(), "john");
        HashMap<String, Integer> proposalOutput = new HashMap<String, Integer>();
        proposalOutput.put("out_offering", 10000);
        taskService.complete(createProposal.getId().longValue(), "john", proposalOutput);
        activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstance.getId(), new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        completedNodes = this.runtimeDataService.getProcessInstanceHistoryCompleted(processInstance.getId(), new QueryContext());
        Assert.assertNotNull((Object)completedNodes);
        Assert.assertEquals((long)5L, (long)completedNodes.size());
        tasks = ((InternalTaskService)taskService).getTasksAssignedByGroup("HR");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary signContract = (TaskSummary)tasks.get(0);
        Task signContractTask = taskService.getTaskById(signContract.getId().longValue());
        contentById = taskService.getContentById(signContractTask.getTaskData().getDocumentContentId());
        Assert.assertNotNull((Object)contentById);
        taskContent = (Map)ContentMarshallerHelper.unmarshall((byte[])contentById.getContent(), null);
        Assert.assertEquals((long)6L, (long)taskContent.size());
        Assert.assertEquals((Object)10000, taskContent.get("in_offering"));
        Assert.assertEquals((Object)"salaboy", taskContent.get("in_name"));
        taskService.claim(signContract.getId().longValue(), "katy");
        taskService.start(signContract.getId().longValue(), "katy");
        HashMap<String, Boolean> signOutput = new HashMap<String, Boolean>();
        signOutput.put("out_signed", true);
        taskService.complete(signContract.getId().longValue(), "katy", signOutput);
        activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(processInstance.getId(), new QueryContext());
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)0L, (long)activeNodes.size());
        completedNodes = this.runtimeDataService.getProcessInstanceHistoryCompleted(processInstance.getId(), new QueryContext());
        Assert.assertNotNull((Object)completedNodes);
        Assert.assertEquals((long)8L, (long)completedNodes.size());
        int removeAllTasks = ((InternalTaskService)taskService).removeAllTasks();
        logger.debug(">>> Removed Tasks > {}", (Object)removeAllTasks);
    }
}

