/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.cdi.test.support;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.cdi.Kjar;
import org.jbpm.services.cdi.test.ext.DebugTaskLifeCycleEventListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.scanner.MavenRepository;

public abstract class SupportProcessBaseTest
extends AbstractKieServicesBaseTest {
    @Inject
    @Kjar
    protected DeploymentService deploymentService;
    @Inject
    protected DefinitionService bpmn2Service;
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    @Before
    public void prepare() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/support/support.bpmn");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        customDescriptor.getBuilder().addTaskEventListener(new ObjectModel("org.jbpm.services.cdi.test.ext.DebugTaskLifeCycleEventListener", new Object[0]));
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes, resources);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        DebugTaskLifeCycleEventListener.resetEventCounter();
        TestUtil.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
    }

    @Test
    public void testSupportProcess() {
        KModuleDeploymentUnit deploymentUnitSupport = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnitSupport);
        this.units.add((DeploymentUnit)deploymentUnitSupport);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customer", "polymita");
        RuntimeManager managerSupport = this.deploymentService.getRuntimeManager(deploymentUnitSupport.getIdentifier());
        Assert.assertNotNull((Object)managerSupport);
        int currentNumberOfEvents = DebugTaskLifeCycleEventListener.getEventCounter();
        Assert.assertEquals((long)0L, (long)currentNumberOfEvents);
        RuntimeEngine engine = managerSupport.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        ProcessInstance pI = engine.getKieSession().startProcess("support.process", params);
        Assert.assertNotNull((Object)pI);
        TaskService taskService = engine.getTaskService();
        currentNumberOfEvents = DebugTaskLifeCycleEventListener.getEventCounter();
        Assert.assertEquals((long)2L, (long)currentNumberOfEvents);
        List tasksAssignedToSalaboy = taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        Assert.assertEquals((long)1L, (long)tasksAssignedToSalaboy.size());
        Assert.assertEquals((Object)"Create Support", (Object)((TaskSummary)tasksAssignedToSalaboy.get(0)).getName());
        TaskSummary createSupportTask = (TaskSummary)tasksAssignedToSalaboy.get(0);
        taskService.start(createSupportTask.getId().longValue(), "salaboy");
        currentNumberOfEvents = DebugTaskLifeCycleEventListener.getEventCounter();
        Assert.assertEquals((long)4L, (long)currentNumberOfEvents);
        Map taskContent = ((InternalTaskService)taskService).getTaskContent(createSupportTask.getId().longValue());
        Assert.assertEquals((Object)"polymita", taskContent.get("input_customer"));
        Map taskOutputMappings = this.bpmn2Service.getTaskOutputMappings(deploymentUnitSupport.getIdentifier(), "support.process", createSupportTask.getName());
        Assert.assertEquals((long)1L, (long)taskOutputMappings.size());
        Assert.assertEquals((Object)"output_customer", taskOutputMappings.keySet().iterator().next());
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("output_customer", "polymita/redhat");
        taskService.complete(createSupportTask.getId().longValue(), "salaboy", output);
        currentNumberOfEvents = DebugTaskLifeCycleEventListener.getEventCounter();
        Assert.assertEquals((long)8L, (long)currentNumberOfEvents);
        tasksAssignedToSalaboy = taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        Assert.assertEquals((long)1L, (long)tasksAssignedToSalaboy.size());
        Assert.assertEquals((Object)"Resolve Support", (Object)((TaskSummary)tasksAssignedToSalaboy.get(0)).getName());
        TaskSummary resolveSupportTask = (TaskSummary)tasksAssignedToSalaboy.get(0);
        taskService.start(resolveSupportTask.getId().longValue(), "salaboy");
        currentNumberOfEvents = DebugTaskLifeCycleEventListener.getEventCounter();
        Assert.assertEquals((long)10L, (long)currentNumberOfEvents);
        taskService.complete(resolveSupportTask.getId().longValue(), "salaboy", null);
        currentNumberOfEvents = DebugTaskLifeCycleEventListener.getEventCounter();
        Assert.assertEquals((long)14L, (long)currentNumberOfEvents);
        tasksAssignedToSalaboy = taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        Assert.assertEquals((long)1L, (long)tasksAssignedToSalaboy.size());
        Assert.assertEquals((Object)"Notify Customer", (Object)((TaskSummary)tasksAssignedToSalaboy.get(0)).getName());
        TaskSummary notifySupportTask = (TaskSummary)tasksAssignedToSalaboy.get(0);
        taskService.start(notifySupportTask.getId().longValue(), "salaboy");
        currentNumberOfEvents = DebugTaskLifeCycleEventListener.getEventCounter();
        Assert.assertEquals((long)16L, (long)currentNumberOfEvents);
        output = new HashMap();
        output.put("output_solution", "solved today");
        taskService.complete(notifySupportTask.getId().longValue(), "salaboy", output);
        currentNumberOfEvents = DebugTaskLifeCycleEventListener.getEventCounter();
        Assert.assertEquals((long)18L, (long)currentNumberOfEvents);
    }
}

