/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.cdi.producer;

import java.util.HashSet;
import java.util.List;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManager;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.task.HumanTaskConfigurator;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.impl.command.CommandBasedTaskService;
import org.jbpm.services.task.lifecycle.listeners.BAMTaskEventListener;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanTaskServiceProducer {
    private static final Logger logger = LoggerFactory.getLogger(HumanTaskServiceProducer.class);
    final String mode = System.getProperty("org.jbpm.cdi.taskservice.mode", "new");
    @Inject
    private Instance<UserGroupCallback> userGroupCallback;
    @Inject
    private Instance<UserInfo> userInfo;
    @Inject
    @Any
    private Instance<TaskLifeCycleEventListener> taskListeners;
    @Inject
    @Any
    private Instance<List<TaskLifeCycleEventListener>> listOfListeners;
    @Inject
    @PersistenceUnit(unitName="org.jbpm.domain")
    private EntityManagerFactory emf;
    private InternalTaskService taskService;

    @Produces
    public CommandBasedTaskService produceTaskService() {
        if (this.mode.equalsIgnoreCase("none")) {
            return null;
        }
        if (this.taskService == null) {
            HumanTaskConfigurator configurator = this.createHumanTaskConfigurator();
            if (this.mode.equalsIgnoreCase("singleton")) {
                this.taskService = (CommandBasedTaskService)configurator.getTaskService();
            } else {
                return (CommandBasedTaskService)configurator.getTaskService();
            }
        }
        return (CommandBasedTaskService)this.taskService;
    }

    protected HumanTaskConfigurator createHumanTaskConfigurator() {
        HumanTaskConfigurator configurator = HumanTaskServiceFactory.newTaskServiceConfigurator();
        this.configureHumanTaskConfigurator(configurator);
        return configurator;
    }

    protected void configureHumanTaskConfigurator(HumanTaskConfigurator configurator) {
        configurator.entityManagerFactory(this.emf).userGroupCallback(this.safeGet(this.userGroupCallback)).userInfo(this.safeGet(this.userInfo));
        DeploymentDescriptorManager manager = new DeploymentDescriptorManager("org.jbpm.domain");
        DeploymentDescriptor descriptor = manager.getDefaultDescriptor();
        if (!descriptor.getAuditMode().equals((Object)AuditMode.NONE)) {
            JPATaskLifeCycleEventListener listener = new JPATaskLifeCycleEventListener(false);
            BAMTaskEventListener bamListener = new BAMTaskEventListener(false);
            if (!"org.jbpm.domain".equals(descriptor.getAuditPersistenceUnit())) {
                EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(descriptor.getAuditPersistenceUnit());
                listener = new JPATaskLifeCycleEventListener(emf);
                bamListener = new BAMTaskEventListener(emf);
            }
            configurator.listener((TaskLifeCycleEventListener)listener);
            configurator.listener((TaskLifeCycleEventListener)bamListener);
        }
        try {
            for (TaskLifeCycleEventListener listener : this.taskListeners) {
                configurator.listener(listener);
                logger.debug("Registering listener {}", (Object)listener);
            }
        }
        catch (Exception e) {
            logger.debug("Cannot add listeners to task service due to {}", (Object)e.getMessage());
        }
    }

    protected <T> T safeGet(Instance<T> instance) {
        try {
            Object object = instance.get();
            logger.debug("About to set object {} on task service", object);
            return (T)object;
        }
        catch (AmbiguousResolutionException e) {
            HashSet available = new HashSet();
            for (Object object : instance) {
                available.add(object);
            }
            if (available.size() == 1) {
                return (T)available.iterator().next();
            }
            throw e;
        }
        catch (Throwable e) {
            logger.debug("Cannot get value of of instance {} due to {}", instance, (Object)e.getMessage());
            return null;
        }
    }
}

