/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.cdi.impl;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.cdi.Activate;
import org.jbpm.services.cdi.Deactivate;
import org.jbpm.services.cdi.Deploy;
import org.jbpm.services.cdi.Kjar;
import org.jbpm.services.cdi.RequestScopedBackupIdentityProvider;
import org.jbpm.services.cdi.Undeploy;
import org.jbpm.services.cdi.impl.IdentityProviderCDIWrapper;
import org.jbpm.services.cdi.impl.manager.InjectableRegisterableItemsFactory;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.internal.identity.IdentityProvider;

@ApplicationScoped
@Kjar
public class DeploymentServiceCDIImpl
extends KModuleDeploymentService {
    @Inject
    private BeanManager beanManager;
    @Inject
    @Deploy
    protected Event<DeploymentEvent> deploymentEvent;
    @Inject
    @Undeploy
    protected Event<DeploymentEvent> undeploymentEvent;
    @Inject
    @Activate
    protected Event<DeploymentEvent> activateEvent;
    @Inject
    @Deactivate
    protected Event<DeploymentEvent> deactivateEvent;
    @Inject
    private Instance<RequestScopedBackupIdentityProvider> backupProviders;

    @PostConstruct
    public void onInit() {
        super.onInit();
    }

    @PreDestroy
    public void shutdown() {
        super.shutdown();
    }

    public void notifyOnDeploy(DeploymentUnit unit, DeployedUnit deployedUnit) {
        if (this.deploymentEvent != null) {
            this.deploymentEvent.fire((Object)new DeploymentEvent(unit.getIdentifier(), deployedUnit));
        }
    }

    public void notifyOnUnDeploy(DeploymentUnit unit, DeployedUnit deployedUnit) {
        if (this.undeploymentEvent != null && deployedUnit != null) {
            this.undeploymentEvent.fire((Object)new DeploymentEvent(unit.getIdentifier(), deployedUnit));
        }
    }

    public void notifyOnActivate(DeploymentUnit unit, DeployedUnit deployedUnit) {
        if (this.activateEvent != null && deployedUnit != null) {
            this.activateEvent.fire((Object)new DeploymentEvent(unit.getIdentifier(), deployedUnit));
        }
    }

    public void notifyOnDeactivate(DeploymentUnit unit, DeployedUnit deployedUnit) {
        if (this.deactivateEvent != null && deployedUnit != null) {
            this.deactivateEvent.fire((Object)new DeploymentEvent(unit.getIdentifier(), deployedUnit));
        }
    }

    @Inject
    public void setBpmn2Service(DefinitionService bpmn2Service) {
        super.setBpmn2Service(bpmn2Service);
    }

    @Inject
    public void setManagerFactory(RuntimeManagerFactory managerFactory) {
        super.setManagerFactory(managerFactory);
    }

    @Inject
    @PersistenceUnit(unitName="org.jbpm.domain")
    public void setEmf(EntityManagerFactory emf) {
        super.setEmf(emf);
    }

    @Inject
    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        super.setRuntimeDataService(runtimeDataService);
    }

    @Inject
    public void setIdentityProvider(IdentityProvider identityProvider) {
        super.setIdentityProvider((IdentityProvider)new IdentityProviderCDIWrapper(identityProvider, this.backupProviders));
    }

    @Inject
    public void setFormManagerService(FormManagerService formManagerService) {
        super.setFormManagerService(formManagerService);
    }

    @Inject
    public void setExecutorService(Instance<ExecutorService> executorService) {
        if (!executorService.isUnsatisfied()) {
            super.setExecutorService((ExecutorService)executorService.get());
        }
    }

    protected RegisterableItemsFactory getRegisterableItemsFactory(AuditEventBuilder auditLoggerBuilder, KieContainer kieContainer, KModuleDeploymentUnit unit) {
        return InjectableRegisterableItemsFactory.getFactory(this.beanManager, auditLoggerBuilder, kieContainer, unit.getKsessionName());
    }
}

