/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xes.dataset;

import java.util.List;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.sql.SQLDataSetProvider;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookupBuilder;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.impl.SQLDataSetDefBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.xes.dataset.DataSetService;
import org.jbpm.xes.dataset.QueryDefinitionLoader;
import org.jbpm.xes.model.QueryDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetServiceImpl
implements DataSetService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetServiceImpl.class);
    private DataSetDefRegistry dataSetDefRegistry = DataSetCore.get().getDataSetDefRegistry();
    private DataSetManager dataSetManager = DataSetCore.get().getDataSetManager();
    private DataSetProviderRegistry providerRegistry = DataSetCore.get().getDataSetProviderRegistry();

    public DataSetServiceImpl(Supplier<DataSource> dataSourceResolver) {
        SQLDataSetProvider sqlDataSetProvider = SQLDataSetProvider.get();
        sqlDataSetProvider.setDataSourceLocator(def -> (DataSource)dataSourceResolver.get());
        this.providerRegistry.registerDataProvider((DataSetProvider)sqlDataSetProvider);
        List<QueryDefinition> queryDefinitions = QueryDefinitionLoader.get().loadQueryDefinitions();
        queryDefinitions.forEach(q -> this.registerDataSetDefinition((QueryDefinition)q));
    }

    protected void registerDataSetDefinition(QueryDefinition queryDefinition) {
        LOGGER.info("Loaded query definition: {}", (Object)queryDefinition);
        SQLDataSetDefBuilderImpl builder = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetDefFactory.newSQLDataSetDef().uuid(queryDefinition.getName())).name(queryDefinition.getTarget() + "-" + queryDefinition.getName())).dataSource("xes").dbSQL(queryDefinition.getExpression(), true);
        DataSetDef dataSetDef = builder.buildDef();
        dataSetDef.setPublic(false);
        this.dataSetDefRegistry.registerDataSetDef(dataSetDef);
        LOGGER.info("Data Set registered {}", (Object)dataSetDef);
    }

    @Override
    public DataSet findTraces(ColumnFilter ... filters) {
        DataSetLookupBuilder builder = (DataSetLookupBuilder)DataSetLookupFactory.newDataSetLookupBuilder().dataset("jbpmXESTraces");
        builder.filter(filters);
        builder.sort("id", SortOrder.ASCENDING);
        DataSet result = this.dataSetManager.lookupDataSet(builder.buildLookup());
        LOGGER.debug("Data set query result: {}", (Object)result);
        return result;
    }

    @Override
    public DataSet findEvents(ColumnFilter ... filters) {
        DataSetLookupBuilder builder = (DataSetLookupBuilder)DataSetLookupFactory.newDataSetLookupBuilder().dataset("jbpmXESEvents");
        builder.filter(filters);
        builder.sort("processInstanceId", SortOrder.ASCENDING);
        builder.sort("log_date", SortOrder.ASCENDING);
        DataSet result = this.dataSetManager.lookupDataSet(builder.buildLookup());
        LOGGER.debug("Data set query result: {}", (Object)result);
        return result;
    }
}

