/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xes;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.impl.DataSetImpl;
import org.jbpm.xes.XESExportServiceImpl;
import org.jbpm.xes.XESLogMarshaller;
import org.jbpm.xes.XESProcessFilter;
import org.jbpm.xes.dataset.DataSetService;
import org.jbpm.xes.model.LogType;
import org.jbpm.xes.model.TraceType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class XESExportServiceTest {
    @Mock
    private DataSetService dataSetService;
    @InjectMocks
    private XESExportServiceImpl xesExportService;

    @Test
    public void testExport() throws Exception {
        DataSetImpl tracesDataSet = new DataSetImpl();
        Integer processInstanceId = 1;
        tracesDataSet.addColumn("processInstanceId", ColumnType.NUMBER, Collections.singletonList(processInstanceId));
        tracesDataSet.addColumn("id", ColumnType.NUMBER, Collections.singletonList(1));
        tracesDataSet.addColumn("user_identity", ColumnType.LABEL, Collections.singletonList("admin"));
        tracesDataSet.addColumn("correlationKey", ColumnType.LABEL, Collections.singletonList(1));
        tracesDataSet.addColumn("processVersion", ColumnType.LABEL, Collections.singletonList("1.0"));
        tracesDataSet.addColumn("processInstanceDescription", ColumnType.LABEL, Collections.singletonList("Evaluation"));
        tracesDataSet.addColumn("parentProcessInstanceId", ColumnType.NUMBER, Collections.singletonList(-1));
        tracesDataSet.addColumn("status", ColumnType.NUMBER, Collections.singletonList(1));
        tracesDataSet.addColumn("slaCompliance", ColumnType.NUMBER, Collections.singletonList(0));
        Mockito.when((Object)this.dataSetService.findTraces((ColumnFilter[])Mockito.any())).thenReturn((Object)tracesDataSet);
        DataSetImpl eventsDataSet = new DataSetImpl();
        eventsDataSet.addColumn("type", ColumnType.NUMBER, Arrays.asList(0, 1));
        eventsDataSet.addColumn("processInstanceId", ColumnType.NUMBER, Arrays.asList(processInstanceId, processInstanceId));
        eventsDataSet.addColumn("log_date", ColumnType.DATE, Arrays.asList(new Date(), new Date()));
        eventsDataSet.addColumn("nodeName", ColumnType.LABEL, Arrays.asList("", ""));
        eventsDataSet.addColumn("nodeType", ColumnType.LABEL, Arrays.asList("StartNode", "StartNode"));
        eventsDataSet.addColumn("nodeInstanceId", ColumnType.LABEL, Arrays.asList("1", "1"));
        eventsDataSet.addColumn("id", ColumnType.NUMBER, Arrays.asList(1, 2));
        eventsDataSet.addColumn("nodeId", ColumnType.LABEL, Arrays.asList("_09AE0EB5-703B-4439-A83D-C92A10C28F63", "_09AE0EB5-703B-4439-A83D-C92A10C28F63"));
        eventsDataSet.addColumn("workItemId", ColumnType.NUMBER, Arrays.asList(null, null));
        Mockito.when((Object)this.dataSetService.findEvents((ColumnFilter[])Matchers.anyVararg())).thenReturn((Object)eventsDataSet);
        String xml = this.xesExportService.export(XESProcessFilter.builder().withProcessId("processId").build());
        XESLogMarshaller marshaller = new XESLogMarshaller();
        LogType log = marshaller.unmarshall(xml);
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((long)4L, (long)log.getExtension().size());
        Assert.assertEquals((long)3L, (long)log.getStringOrDateOrInt().size());
        Assert.assertEquals((long)2L, (long)log.getGlobal().size());
        Assert.assertEquals((long)4L, (long)log.getClassifier().size());
        Assert.assertEquals((long)1L, (long)log.getTrace().size());
        Assert.assertEquals((long)2L, (long)((TraceType)log.getTrace().get(0)).getEvent().size());
    }
}

