/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xes;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.jbpm.xes.XESExportServiceImpl;
import org.jbpm.xes.XESLogMarshaller;
import org.jbpm.xes.XESPersistenceBase;
import org.jbpm.xes.XESProcessFilter;
import org.jbpm.xes.dataset.DataSetService;
import org.jbpm.xes.dataset.DataSetServiceImpl;
import org.jbpm.xes.model.LogType;
import org.jbpm.xes.model.TraceType;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;

public class XESProcessExportTest
extends XESPersistenceBase {
    @Test
    public void testHelloProcess() throws Exception {
        this.createRuntimeManager(new String[]{"hello.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        int instances = 5;
        IntStream.range(0, instances).forEach(i -> {
            ProcessInstance processInstance = ksession.startProcess("hello");
            this.assertProcessInstanceCompleted(processInstance.getId());
            this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Hello", "End"});
        });
        DataSetServiceImpl dataSetService = new DataSetServiceImpl(() -> this.pds);
        XESExportServiceImpl service = new XESExportServiceImpl();
        service.setDataSetService((DataSetService)dataSetService);
        String xml = service.export(XESProcessFilter.builder().withProcessId("hello").withAllNodeTypes().build());
        XESLogMarshaller marshaller = new XESLogMarshaller();
        LogType log = marshaller.unmarshall(xml);
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((long)4L, (long)log.getExtension().size());
        Assert.assertEquals((long)3L, (long)log.getStringOrDateOrInt().size());
        Assert.assertEquals((long)2L, (long)log.getGlobal().size());
        Assert.assertEquals((long)4L, (long)log.getClassifier().size());
        Assert.assertEquals((long)instances, (long)log.getTrace().size());
        IntStream.range(0, instances).forEach(i -> Assert.assertEquals((long)6L, (long)((TraceType)log.getTrace().get(i)).getEvent().size()));
    }

    @Test
    public void testHelloProcessWithFilters() throws Exception {
        this.createRuntimeManager(new String[]{"hello.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        int instances = 5;
        IntStream.range(0, instances).forEach(i -> {
            ProcessInstance processInstance = ksession.startProcess("hello");
            this.assertProcessInstanceCompleted(processInstance.getId());
            this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Hello", "End"});
        });
        DataSetServiceImpl dataSetService = new DataSetServiceImpl(() -> this.pds);
        XESExportServiceImpl service = new XESExportServiceImpl();
        service.setDataSetService((DataSetService)dataSetService);
        XESProcessFilter filter = XESProcessFilter.builder().withProcessId("hello").withProcessVersion("1.0").withStatus(Arrays.asList(2)).withNodeInstanceLogType(Integer.valueOf(1)).build();
        String xml = service.export(filter);
        XESLogMarshaller marshaller = new XESLogMarshaller();
        LogType log = marshaller.unmarshall(xml);
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((long)4L, (long)log.getExtension().size());
        Assert.assertEquals((long)3L, (long)log.getStringOrDateOrInt().size());
        Assert.assertEquals((long)2L, (long)log.getGlobal().size());
        Assert.assertEquals((long)4L, (long)log.getClassifier().size());
        Assert.assertEquals((long)instances, (long)log.getTrace().size());
        IntStream.range(0, instances).forEach(i -> Assert.assertEquals((long)1L, (long)((TraceType)log.getTrace().get(i)).getEvent().size()));
    }
}

