/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xes;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSource;
import org.jbpm.xes.XESExportServiceImpl;
import org.jbpm.xes.XESProcessFilter;
import org.jbpm.xes.dataset.DataSetServiceImpl;

public class XESExportMain {
    public static void main(String[] args) {
        Options options = XESExportMain.getOptions();
        DefaultParser parser = new DefaultParser();
        try (BasicDataSource ds = new BasicDataSource();){
            CommandLine line = parser.parse(options, args);
            ds.setDriverClassName(line.getOptionValue("driver"));
            ds.setUrl(line.getOptionValue("url"));
            ds.setUsername(line.getOptionValue("user"));
            ds.setPassword(line.getOptionValue("password"));
            ds.setDefaultReadOnly(Boolean.valueOf(true));
            ds.getConnection().close();
            DataSetServiceImpl dataSetService = new DataSetServiceImpl(() -> ds);
            XESExportServiceImpl service = new XESExportServiceImpl();
            service.setDataSetService(dataSetService);
            XESProcessFilter.Builder filter = XESProcessFilter.builder();
            filter.withProcessId(line.getOptionValue("process"));
            if (line.hasOption("version")) {
                filter.withProcessVersion(line.getOptionValue("version"));
            }
            if (line.hasOption("status")) {
                ArrayList<Integer> status = new ArrayList<Integer>();
                for (String statusLine : line.getOptionValues("status")) {
                    try {
                        Integer pStatus = Integer.valueOf(statusLine);
                        if (pStatus < 0 || pStatus > 4) continue;
                        status.add(pStatus);
                    }
                    catch (NumberFormatException ex) {
                        System.err.println("Invalid process status number for input: " + statusLine + ", valid status are number between 0 and 4.");
                    }
                }
                if (!status.isEmpty()) {
                    filter.withStatus(status);
                }
            }
            if (line.hasOption("logtype")) {
                filter.withNodeInstanceLogType(Integer.valueOf(line.getOptionValue("logtype")));
            }
            if (line.hasOption("nodetypes")) {
                filter.withAllNodeTypes();
            }
            String xml = service.export(filter.build());
            if (line.hasOption("file")) {
                FileUtils.write((File)new File(line.getOptionValue("file")), (CharSequence)xml, (String)"UTF-8");
            } else {
                System.out.println(xml);
            }
        }
        catch (ParseException exp) {
            System.err.println("Parsing options failed. Reason: " + exp.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("xes", options, true);
            System.exit(-1);
        }
        catch (Exception ex) {
            System.err.println("Failed to execute export due to: " + ex.getMessage());
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"user").argName("user").required().hasArg().desc("Database username").build());
        options.addOption(Option.builder((String)"password").argName("password").hasArg().desc("Database password").build());
        options.addOption(Option.builder((String)"url").argName("url").required().hasArg().desc("Database url").build());
        options.addOption(Option.builder((String)"driver").argName("driver").required().hasArg().desc("Database driver class name").build());
        options.addOption(Option.builder((String)"file").argName("file").hasArg().desc("File name to save result XES. Default will print in the console.").build());
        options.addOption(Option.builder((String)"process").argName("process").required().hasArg().desc("Process Id to export").build());
        options.addOption(Option.builder((String)"version").argName("version").hasArg().desc("Process version to export").build());
        options.addOption(Option.builder((String)"status").argName("status").hasArgs().valueSeparator(',').desc("Process status to export. Valid status are from 0 to 4, comma separated.").build());
        options.addOption(Option.builder((String)"nodetypes").argName("a").desc("Export all node type. Default will only export relevant activities.").build());
        options.addOption(Option.builder((String)"logtype").argName("logtype").hasArg().desc("Use 0 for node entered events or 1 for exit events. Default will export all types.").build());
        return options;
    }
}

