/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xes;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSource;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.xes.XESExportServiceImpl;
import org.jbpm.xes.XESProcessFilter;
import org.jbpm.xes.dataset.DataSetService;
import org.jbpm.xes.dataset.DataSetServiceImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;

public class EvaluationExport
extends JbpmJUnitBaseTestCase {
    private BasicDataSource xesDataSource;

    public EvaluationExport() {
        super(true, true);
    }

    public static BasicDataSource setupDataSource(String connectURI) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName("org.h2.Driver");
        ds.setUrl(connectURI);
        ds.setUsername("sa");
        ds.setPassword("");
        return ds;
    }

    @Before
    public void setup() {
        this.xesDataSource = EvaluationExport.setupDataSource("jdbc:h2:mem:jbpm-db;MVCC=true");
    }

    @After
    public void cleanup() throws Exception {
        if (this.xesDataSource != null) {
            this.xesDataSource.close();
        }
    }

    @Test
    @Ignore
    public void exportProcess() throws Exception {
        String administrator = "Administrator";
        this.createRuntimeManager(new String[]{"evaluation.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        ArrayList pIds = new ArrayList();
        int instances = 100;
        IntStream.range(0, instances).forEach(i -> {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("employee", "Administrator");
            vars.put("reason", "test instance " + i);
            vars.put("performance", RandomUtils.nextInt((int)0, (int)11));
            ProcessInstance processInstance = ksession.startProcess("evaluation", vars);
            this.assertProcessInstanceActive(processInstance.getId(), ksession);
            pIds.add(processInstance.getId());
        });
        TaskService taskService = this.getRuntimeEngine().getTaskService();
        List tasks = taskService.getTasksAssignedAsBusinessAdministrator("Administrator", null);
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        CountDownLatch count = new CountDownLatch(instances * 3);
        tasks.forEach(t -> executorService.submit(() -> {
            taskService.start(t.getId().longValue(), "Administrator");
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            taskService.complete(t.getId().longValue(), "Administrator", null);
            count.countDown();
            taskService.getTasksByProcessInstanceId(t.getProcessInstanceId().longValue()).stream().filter(newTaskId -> !newTaskId.equals(t.getId())).forEach(taskId -> executorService.submit(() -> {
                Task task = taskService.getTaskById(taskId.longValue());
                String userId = "HR Evaluation".equals(task.getName()) ? "mary" : "john";
                taskService.claim(taskId.longValue(), userId);
                taskService.start(taskId.longValue(), userId);
                if ("HR Evaluation".equals(task.getName())) {
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                taskService.complete(taskId.longValue(), userId, null);
                count.countDown();
            }));
        }));
        count.await();
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.MINUTES);
        pIds.forEach(id -> this.assertProcessInstanceCompleted((long)id));
        DataSetServiceImpl dataSetService = new DataSetServiceImpl(() -> this.xesDataSource);
        XESExportServiceImpl service = new XESExportServiceImpl();
        service.setDataSetService((DataSetService)dataSetService);
        String xml = service.export(XESProcessFilter.builder().withProcessId("evaluation").build());
        FileUtils.write((File)new File("evaluation.xes"), (CharSequence)xml);
    }
}

