/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.xes;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jbpm.xes.XESExportMain;
import org.jbpm.xes.XESLogMarshaller;
import org.jbpm.xes.XESPersistenceBase;
import org.jbpm.xes.model.AttributeStringType;
import org.jbpm.xes.model.LogType;
import org.jbpm.xes.model.TraceType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XESExportMainTest
extends XESPersistenceBase {
    private static final String XES_IEEE_SCHEMA = "xes-ieee-1849-2016.xsd";
    private static final String PROCESS = "com.sample.bpmn.hello";
    private static final String ABORTED_XES_FILE = "aborted.xes";
    private static final String ACTIVE_COMPLETED_XES_FILE = "activeCompleted.xes";
    private static final String COMPLETED_XES_FILE = "completed.xes";
    private static final String COMPLETED_EE_XES_FILE = "completedEnterExit.xes";
    private static final String COMPLETED_REL_XES_FILE = "completedRelevant.xes";
    private static final String COMPLETED_1_2_XES_FILE = "completed12.xes";
    private static final String ALL_STATUS_XES_FILE = "allStatus.xes";
    private static final List<String> xesFiles = Arrays.asList("aborted.xes", "activeCompleted.xes", "completed.xes", "completedEnterExit.xes", "completedRelevant.xes", "allStatus.xes");
    private static final Logger logger = LoggerFactory.getLogger(XESExportMainTest.class);
    private String driver;
    private String url;
    private String password;
    private String user;
    private KieSession ksession;
    private TaskService taskService;
    private RuntimeEngine runtimeEngine;

    @Before
    public void setup() {
        this.getMainInputParams();
        this.createRuntimeManager(new String[]{"humantask.bpmn"});
        this.runtimeEngine = this.getRuntimeEngine();
        this.ksession = this.runtimeEngine.getKieSession();
        this.taskService = this.runtimeEngine.getTaskService();
        this.activeProcess();
        this.completeProcess();
        this.abortedProcess();
    }

    private void getMainInputParams() {
        this.user = this.dsProps.getProperty("user");
        this.password = this.dsProps.getProperty("password");
        this.url = this.dsProps.getProperty("url");
        this.driver = this.dsProps.getProperty("driverClassName");
    }

    private void activeProcess() {
        this.ksession.startProcess(PROCESS);
        this.startAndCompleteTask("john");
    }

    private void startAndCompleteTask(String resource) {
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner(resource, "en-UK");
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        this.taskService.start(taskSummary.getId().longValue(), resource);
        this.taskService.complete(taskSummary.getId().longValue(), resource, null);
    }

    private void completeProcess() {
        this.activeProcess();
        this.startAndCompleteTask("mary");
    }

    private void abortedProcess() {
        ProcessInstance instance = this.ksession.startProcess(PROCESS);
        this.ksession.abortProcessInstance(instance.getId());
    }

    @After
    public void cleanup() throws Exception {
        xesFiles.forEach(f -> {
            try {
                Files.deleteIfExists(Paths.get(f, new String[0]));
            }
            catch (IOException e) {
                logger.debug("Exception during deleting file {} - {}", f, (Object)e.getMessage());
            }
        });
    }

    @Test
    public void testHelloProcessWithoutFilteringStatus() throws Exception {
        XESExportMain.main((String[])new String[]{"-user", this.user, "-password", this.password, "-url", this.url, "-driver", this.driver, "-process", PROCESS, "-file", ALL_STATUS_XES_FILE});
        Assert.assertTrue((boolean)this.validateXML(ALL_STATUS_XES_FILE));
        LogType log = this.assertTraceNodeInstances(ALL_STATUS_XES_FILE, 3);
        this.assertStatus(log, "active", "completed", "aborted");
    }

    @Test
    public void testHelloProcessFilteringStatusCompleteAndActive() throws Exception {
        XESExportMain.main((String[])new String[]{"-user", this.user, "-password", this.password, "-url", this.url, "-driver", this.driver, "-process", PROCESS, "-status", "1,2", "-file", ACTIVE_COMPLETED_XES_FILE});
        Assert.assertTrue((boolean)this.validateXML(ACTIVE_COMPLETED_XES_FILE));
        LogType log = this.assertTraceNodeInstances(ACTIVE_COMPLETED_XES_FILE, 2);
        this.assertStatus(log, "active", "completed");
    }

    @Test
    public void testHelloProcessFilteringStatusAborted() throws Exception {
        XESExportMain.main((String[])new String[]{"-user", this.user, "-password", this.password, "-url", this.url, "-driver", this.driver, "-process", PROCESS, "-status", "3", "-file", ABORTED_XES_FILE});
        Assert.assertTrue((boolean)this.validateXML(ABORTED_XES_FILE));
        LogType log = this.assertTraceNodeInstances(ABORTED_XES_FILE, 1);
        Assert.assertEquals((long)2L, (long)((TraceType)log.getTrace().get(0)).getEvent().size());
        this.assertStatus(log, "aborted");
    }

    @Test
    public void testHelloProcessFilteringStatusCompletedEnterAndExitEvents() throws Exception {
        XESExportMain.main((String[])new String[]{"-user", this.user, "-password", this.password, "-url", this.url, "-driver", this.driver, "-process", PROCESS, "-status", "2", "-file", COMPLETED_EE_XES_FILE});
        Assert.assertTrue((boolean)this.validateXML(COMPLETED_EE_XES_FILE));
        LogType log = this.assertTraceNodeInstances(COMPLETED_EE_XES_FILE, 1);
        Assert.assertEquals((long)4L, (long)((TraceType)log.getTrace().get(0)).getEvent().size());
        this.assertStatus(log, "completed");
    }

    @Test
    public void testHelloProcessFilteringStatusCompletedOnlyExitEvents() throws Exception {
        XESExportMain.main((String[])new String[]{"-user", this.user, "-password", this.password, "-url", this.url, "-driver", this.driver, "-process", PROCESS, "-status", "2", "-file", COMPLETED_XES_FILE, "-logtype", "1"});
        Assert.assertTrue((boolean)this.validateXML(COMPLETED_XES_FILE));
        LogType log = this.assertTraceNodeInstances(COMPLETED_XES_FILE, 1);
        Assert.assertEquals((long)2L, (long)((TraceType)log.getTrace().get(0)).getEvent().size());
        this.assertStatus(log, "completed");
    }

    @Test
    public void testHelloProcessFilteringStatusCompletedRelevantNodes() throws Exception {
        XESExportMain.main((String[])new String[]{"-user", this.user, "-password", this.password, "-url", this.url, "-driver", this.driver, "-process", PROCESS, "-status", "2", "-file", COMPLETED_REL_XES_FILE, "-nodetypes"});
        Assert.assertTrue((boolean)this.validateXML(COMPLETED_REL_XES_FILE));
        LogType log = this.assertTraceNodeInstances(COMPLETED_REL_XES_FILE, 1);
        Assert.assertEquals((long)8L, (long)((TraceType)log.getTrace().get(0)).getEvent().size());
        this.assertStatus(log, "completed");
    }

    @Test
    public void testHelloProcessFilteringStatusCompletedVersion() throws Exception {
        XESExportMain.main((String[])new String[]{"-user", this.user, "-password", this.password, "-url", this.url, "-driver", this.driver, "-process", PROCESS, "-status", "2", "-file", COMPLETED_1_2_XES_FILE, "-version", "1.2"});
        Assert.assertTrue((boolean)this.validateXML(COMPLETED_1_2_XES_FILE));
        LogType log = this.assertTraceNodeInstances(COMPLETED_1_2_XES_FILE, 1);
        Assert.assertEquals((long)4L, (long)((TraceType)log.getTrace().get(0)).getEvent().size());
        this.assertStatus(log, "completed");
    }

    private boolean validateXML(String fileName) {
        File schemaFile = Paths.get("src", "test", "resources", XES_IEEE_SCHEMA).toFile();
        StreamSource xmlFile = new StreamSource(new File(fileName));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = schemaFactory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(xmlFile);
            return true;
        }
        catch (SAXException e) {
            logger.error("Exception during validating xml file {} - {} - {}", new Object[]{fileName, xmlFile.getSystemId(), e.getMessage()});
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private LogType assertTraceNodeInstances(String file, int expected) throws Exception, IOException {
        XESLogMarshaller marshaller = new XESLogMarshaller();
        LogType log = marshaller.unmarshall(new String(Files.readAllBytes(Paths.get(file, new String[0]))));
        Assert.assertEquals((long)expected, (long)log.getTrace().size());
        return log;
    }

    private void assertStatus(LogType log, String ... expectedStatus) {
        List status = log.getTrace().stream().map(t -> t.getStringOrDateOrInt()).flatMap(Collection::stream).filter(AttributeStringType.class::isInstance).map(AttributeStringType.class::cast).filter(sic -> sic.getKey().equals("jbpm:status")).map(st -> new String(st.getValue())).collect(Collectors.toList());
        Assert.assertTrue((boolean)status.containsAll(Arrays.asList(expectedStatus)));
    }
}

