/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.client;

import javax.management.ObjectName;

import org.jboss.bpm.model.Message;

//$Id: MessageListener.java 1879 2008-08-13 13:04:26Z thomas.diesler@jboss.com $

/**
 * A MessageListener that can be registered with the ProcessEngine
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface MessageListener
{
  /**
   * Get the id for this listener
   */
  ObjectName getID();
  
  /** 
   * Catch a message from the process that this listener is registered with 
   */
  void catchMessage(Message message);
}