/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;



// $Id$

/**
 * A Complex Gateway handles situations that are not easily handled through the other types of Gateways. Complex
 * Gateways can also be used to combine a set of linked simple Gateways into a single, more compact situation. Modelers
 * can provide complex expressions that determine the merging and/or splitting behavior of the Gateway.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface ComplexGateway extends Gateway
{
  /**
   * If there are multiple incoming Sequence Flow, an IncomingCondition expression
   * MUST be set by the modeler. This will consist of an expression that can reference
   * Sequence Flow names and/or Process Properties (Data).
   */
  Expression getIncommingCondition();

  /**
   * If there are multiple outgoing Sequence Flow, an OutgoingCondition expression
   * MUST be set by the modeler. This will consist of an expression that can reference
   * (outgoing) Sequence Flow Ids and/or Process Properties (Data).
   */
  Expression getOutgoingCondition();

}