/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;

//$Id: MessageBuilder.java 1959 2008-08-21 13:41:39Z thomas.diesler@jboss.com $

import javax.management.ObjectName;


/**
 * A MessageBuilder can be used to build a {@link Message} dynamically.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface MessageBuilder extends Builder
{
  /**
   * Create a {@link Message} with a given name
   */
  MessageBuilder newMessage(String msgName);

  /**
   * Add a message destination
   */
  MessageBuilder addToRef(ObjectName toRef);
  
  /**
   * Add a message source
   */
  MessageBuilder addFromRef(ObjectName fromRef);
  
  /**
   * Add a message property
   */
  MessageBuilder addProperty(String name, Object value);
  
  /**
   * Add a message property
   */
  MessageBuilder addProperty(String name, Object value, boolean isCorrelation);
  
  /**
   * Get the Message
   */
  Message getMessage();
}