/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;

//$Id$

import java.util.List;


/**
 * An OuputSet, which is used in the definition of common attributes for Activities and for attributes of a Process
 * 
 * @author thomas.diesler@jboss.com
 * @since 21-Jul-2008
 */
public interface OutputSet extends MutablePropertySupport
{
  /**
   * Zero or more ArtifactOutputs MAY be defined for each OutputSet. For the
   * combination of ArtifactOutputs and PropertyOutputs, there MUST be at least one
   * item defined for the OutputSet. An ArtifactOutput is an {@link Artifact}, 
   * usually a DataObject. 
   */
  List<ArtifactOutput> getArtifactOutputs();

  /**
   * Zero or more PropertyInputs MAY be defined for each InputSet. For the
   * combination of ArtifactInputs and PropertyInputs, there MUST be at least one
   * item defined for the InputSet.
   */
  List<Property> getProperties();
}
