/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;

import org.jboss.bpm.client.DialectHandler;
import org.jboss.bpm.model.Assignment.AssignTime;
import org.jboss.bpm.model.Expression.ExpressionLanguage;
import org.jboss.bpm.runtime.ExecutionHandler;
import org.jboss.bpm.runtime.FlowHandler;
import org.jboss.bpm.runtime.SignalHandler;


// $Id: ProcessBuilder.java 1993 2008-08-25 10:45:32Z thomas.diesler@jboss.com $

/**
 * The ProcessBuilder can be used to build a {@link Process} dynamically.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface ProcessBuilder extends Builder
{
  /**
   * Add a {@link Process} with a given name
   */
  ProcessBuilder addProcess(String name);

  /**
   * Add all elements from another {@link Process}.
   * This is typically used by a {@link DialectHandler} when processing an include. 
   */
  ProcessBuilder addProcess(Process proc);
  
  /**
   * Get the {@link Process}. 
   * <p/> 
   * This is the final call to the ProcessBuilder after all elements have been added.
   * The {@link Process} is initialized and put in state READY
   */
  Process getProcess();

  /**
   * Get the {@link Process} for inclusion in another.
   * <p/> 
   * This is the final call to the ProcessBuilder after all elements have been added.
   * The {@link Process} is not initialized and stays in state CREATED
   */
  Process getProcessForInclude();

  /**
   * Add a SequenceFlow with a given name
   */
  ProcessBuilder addSequenceFlow(String targetName);

  /**
   * Add a MessageFlow with a given name
   */
  ProcessBuilder addMessageFlow(String targetName);

  /**
   * Add a SartEvent with a given name
   */
  EventBuilder addStartEvent(String name);

  /**
   * Add an IntermediateEvent with a given name
   */
  EventBuilder addEvent(String name);

  /**
   * Add an EndEvent with a given name
   */
  EventBuilder addEndEvent(String name);

  /**
   * Add a Task of {@link Task.TaskType} NONE with a given name
   */
  TaskBuilder addTask(String name);

  /**
   * Add a Task with a given name and type
   */
  TaskBuilder addTask(String name, Task.TaskType type);

  /**
   * Add a Gateway with a given name
   */
  GatewayBuilder addGateway(String name, Gateway.GatewayType type);

  /**
   * Add a {@link Message} with a given name.
   */
  MessageBuilder addMessage(String name);
  
  /**
   * Add a process property
   */
  ProcessBuilder addProperty(String name, String value);
  
  /**
   * Add an Assignment to the Process or the current FlowObject.
   */
  ProcessBuilder addAssignment(AssignTime time, ExpressionLanguage lang, String fromExpr, String toProp);
  
  /**
   * Add an {@link ExecutionHandler} with a given Class
   */
  ProcessBuilder addExecutionHandler(Class<?> clazz);

  /**
   * Add an {@link FlowHandler} with a given Class
   */
  ProcessBuilder addFlowHandler(Class<?> clazz);

  /**
   * Add an {@link SignalHandler} with a given Class
   */
  ProcessBuilder addSignalHandler(Class<?> clazz);
}