/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;

// $Id: ProcessBuilderFactory.java 1959 2008-08-21 13:41:39Z thomas.diesler@jboss.com $

import org.jboss.bpm.client.ProcessEngine;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.util.KernelLocator;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;

/**
 * A Factory for the {@link ProcessBuilder}.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public abstract class ProcessBuilderFactory extends BuilderFactory
{
  /** The bean name - jBPMProcessBuilderFactory */
  public static final String BEAN_NAME = "jBPMProcessBuilderFactory";

  // Hide the constructor
  protected ProcessBuilderFactory()
  {
  }

  /**
   * Get a ProcessBuilderFactory instance.
   */
  @SuppressWarnings("deprecation")
  public static ProcessBuilderFactory newInstance()
  {
    // Make sure the engine is bootstrapped
    ProcessEngine.locateProcessEngine();
    Kernel kernel = KernelLocator.getKernel();
    KernelRegistryEntry entry = kernel.getRegistry().getEntry(BEAN_NAME);
    return (ProcessBuilderFactory)entry.getTarget();
  }

  /**
   * Get a {@link ProcessBuilder}.
   */
  public abstract ProcessBuilder newProcessBuilder();
}