/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;



// $Id: Property.java 1936 2008-08-19 23:22:38Z thomas.diesler@jboss.com $

/**
 * A Property, which is used in the definition of attributes for a Process and common activity attributes
 * 
 * @author thomas.diesler@jboss.com
 * @since 21-Jul-2008
 */
public interface Property 
{
  /**
   * Supported property types
   */
  public enum PropertyType
  {
    String, Object
  }
  
  /**
   * Each Property has a Name (e.g., name=”Customer Name”).
   */
  String getName();
  
  /**
   * Each Property has a Type (e.g., type=”String”). Properties may be defined
   * hierarchically.
   */
  PropertyType getPropertyType();
  
  /**
   * Each Property MAY have a value expression specified.
   */
  Expression getExpression();
  
  /**
   * Get the body of the expression value.
   */
  Object getValue();
  
  /**
   * Get the body of the expression value.
   */
  <T> T getValue(Class<T> T);
  
  /**
   * If the Correlation attribute is set to True, then the Property is marked to be used for
   * correlation (e.g., for incoming Messages).
   */
  boolean isCorrelation();
}
