/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;

import org.jboss.bpm.model.Message.Implementation;



//$Id$

/**
 * A Receive Task is a simple Task that is designed to wait for a message to arrive from an external participant
 * (relative to the Business Process). Once the message has been received, the Task is completed.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface ReceiveTask extends Task
{
  /**
   * A Message for the MessageRef attribute MUST be entered. This indicates that the Message will be received by the
   * Task. The Message in this context is equivalent to an in-only message pattern (Web service). One or more
   * corresponding incoming Message Flows MAY be shown on the diagram. However, the display of the Message Flow is not
   * required. The Message is applied to all incoming Message Flow, but can arrive for only one of the incoming Message
   * Flow for a single instance of the Task.
   */
  Message getMessageRef();

  /**
   * Receive Tasks can be defined as the instantiation mechanism for the Process with the Instantiate attribute. This
   * attribute MAY be set to true if the Task is the first activity after the Start Event or a starting Task if there is
   * no Start Event (i.e., there are no incoming Sequence Flow). Multiple Tasks MAY have this attribute set to True.
   */
  boolean isInstantiate();

  /**
   * This attribute specifies the technology that will be used to send or receive the message. A Web service is the
   * default technology.
   */
  Implementation getImplementation();
}