/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;



//$Id$

/**
 * A Sequence Flow is used to show the order that activities will be performed in a Process. Each Flow has only one
 * source and only one target. The source and target must be from the set of the following Flow Objects: Events (Start,
 * Intermediate, and End), Activities (Task and Sub-Process), and Gateways. During performance (or simulation) of the
 * process, a Token will leave the source Flow Object, traverse down the Sequence Flow, and enter the target Flow
 * Object.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface SequenceFlow extends ConnectingObject
{
  /**
   * The ConditionType
   */
  public enum ConditionType
  {
    None, Expression, Default
  }

  /**
   * By default, the ConditionType of a Sequence Flow is None. This means that there is no evaluation at runtime to
   * determine whether or not the Sequence Flow will be used. Once a Token is ready to traverse the Sequence Flow (i.e.,
   * the Source is an activity that has completed), then the Token will do so. The normal, uncontrolled use of Sequence
   * Flow, in a sequence of activities, will have a None ConditionType. A None ConditionType MUST NOT be used if the
   * Source of the Sequence Flow is an Exclusive Data-Based or Inclusive Gateway. The ConditionType attribute MAY be set
   * to Expression if the Source of the Sequence Flow is a Task, a Sub-Process, or a Gateway of type Exclusive-Data-
   * Based or Inclusive. If the ConditionType attribute is set to Expression, then a condition marker SHALL be added to
   * the line if the Sequence Flow is outgoing from an activity. However, a condition indicator MUST NOT be added to the
   * line if the Sequence Flow is outgoing from a Gateway. An Expression ConditionType MUST NOT be used if the Source of
   * the Sequence Flow is an Event-Based Exclusive Gateway, a Complex Gateway, a Parallel Gateway, a Start Event, or an
   * Intermediate Event. In addition, an Expression ConditionType MUST NOT be used if the Sequence Flow is associated
   * with the Default Gate of a Gateway. The ConditionType attribute MAY be set to Default only if the Source of the
   * Sequence Flow is an activity or an Exclusive Data-Based Gateway.
   */
  ConditionType getConditionType();

  /**
   * If the ConditionType attribute is set to Expression, then the ConditionExpression attribute MUST be defined as a
   * valid expression. The expression will be evaluated at runtime. If the result of the evaluation is TRUE, then a
   * Token will be generated and will traverse the Sequence--Subject to any constraints imposed by a Source that is a
   * Gateway.
   */
  Expression getConditionExpression();

}