/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.model;

import java.io.Serializable;

import javax.management.ObjectName;

// $Id: Signal.java 1982 2008-08-22 10:09:27Z thomas.diesler@jboss.com $

/**
 * A Signal thrown by the ProcessEngine
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 08-Jul-2008
 */
public final class Signal implements Serializable
{
  private static final long serialVersionUID = 1L;

  /**
   * Defines the types of supported Signals
   */
  public enum SignalType
  {
    SYSTEM_START_EVENT_ENTER, SYSTEM_START_EVENT_EXIT, SYSTEM_START_TRIGGER,
    SYSTEM_EVENT_ENTER, SYSTEM_EVENT_EXIT, SYSTEM_EVENT_TRIGGER,
    SYSTEM_END_EVENT_ENTER, SYSTEM_END_EVENT_EXIT, SYSTEM_END_TRIGGER, 
    SYSTEM_GATEWAY_ENTER, SYSTEM_GATEWAY_EXIT, 
    SYSTEM_PROCESS_ENTER, SYSTEM_PROCESS_EXIT, 
    SYSTEM_SUB_PROCESS_ENTER, SYSTEM_SUB_PROCESS_EXIT, 
    SYSTEM_TASK_ENTER, SYSTEM_TASK_EXIT, SYSTEM_TASK_TRIGGER,
    USER_SIGNAL
  }

  private SignalType type;
  private String message;
  private ObjectName fromRef;

  /** 
   * Create the signal for a given source and type 
   */
  public Signal(ObjectName fromRef, SignalType type)
  {
    this.fromRef = fromRef;
    this.type = type;
    if (fromRef == null)
      throw new IllegalArgumentException("Signal fromRef cannot be null");
    if (type == null)
      throw new IllegalArgumentException("SignalType cannot be null");
  }

  /** 
   * Create the signal for a given source, type and message 
   */
  public Signal(ObjectName fromRef, SignalType type, String message)
  {
    this(fromRef, type);
    this.message = message;
  }

  public ObjectName getFromRef()
  {
    return fromRef;
  }

  public SignalType getSignalType()
  {
    return type;
  }

  public String getMessage()
  {
    return message;
  }

  public String toString()
  {
    StringBuilder string = new StringBuilder(type + "[" + fromRef);
    if (message != null)
    {
      string.append(":" + message);
    }
    string.append("]");
    return string.toString();
  }
}